/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import java.net.InetAddress;
import java.util.Arrays;

final class PcpMappedPort
implements MappedPort {
    private byte[] nonce;
    private int internalPort;
    private int externalPort;
    private InetAddress externalAddress;
    private PortType portType;
    private long lifetime;

    PcpMappedPort(byte[] nonce, int internalPort, int externalPort, InetAddress externalAddress, PortType portType, long duration) {
        Validate.notNull(nonce);
        Validate.inclusiveBetween(1L, 65535L, internalPort);
        Validate.inclusiveBetween(1L, 65535L, externalPort);
        Validate.notNull(externalAddress);
        Validate.notNull(portType);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, duration);
        Validate.isTrue(nonce.length == 12);
        this.nonce = Arrays.copyOf(nonce, nonce.length);
        this.internalPort = internalPort;
        this.externalPort = externalPort;
        this.externalAddress = externalAddress;
        this.portType = portType;
        this.lifetime = duration;
    }

    byte[] getNonce() {
        return Arrays.copyOf(this.nonce, this.nonce.length);
    }

    @Override
    public int getInternalPort() {
        return this.internalPort;
    }

    @Override
    public int getExternalPort() {
        return this.externalPort;
    }

    @Override
    public InetAddress getExternalAddress() {
        return this.externalAddress;
    }

    @Override
    public PortType getPortType() {
        return this.portType;
    }

    @Override
    public long getLifetime() {
        return this.lifetime;
    }

    public String toString() {
        return "PcpMappedPort{nonce=" + Arrays.toString(this.nonce) + ", internalPort=" + this.internalPort + ", externalPort=" + this.externalPort + ", externalAddress=" + this.externalAddress + ", portType=" + (Object)((Object)this.portType) + ", lifetime=" + this.lifetime + '}';
    }
}

