/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.NetworkUtils;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.TextUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MapperIoUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.PcpMappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.PcpResultCode;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.MapPcpRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.MapPcpResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpOption;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcpPortMapper
implements PortMapper {
    private static final Logger LOG = LoggerFactory.getLogger(PcpPortMapper.class);
    private static final int PORT = 5351;
    private Bus networkBus;
    private InetAddress internalAddress;
    private InetAddress gatewayAddress;
    private Random random;

    public static List<PcpPortMapper> identify(Bus networkBus, Bus processBus, InetAddress ... additionalIps) throws InterruptedException {
        LOG.info("Attempting to identify devices");
        Validate.notNull(networkBus);
        Validate.notNull(processBus);
        Validate.notNull(additionalIps);
        Validate.noNullElements(additionalIps);
        ArrayList<MapperIoUtils.ProcessRequest> processReqs = new ArrayList<MapperIoUtils.ProcessRequest>();
        processReqs.add(new MapperIoUtils.ProcessRequest("netstat", "-rn"));
        processReqs.add(new MapperIoUtils.ProcessRequest("route", "-n"));
        processReqs.add(new MapperIoUtils.ProcessRequest("route", "-n", "get", "default"));
        processReqs.add(new MapperIoUtils.ProcessRequest("ipconfig", new String[0]));
        processReqs.add(new MapperIoUtils.ProcessRequest("ifconfig", new String[0]));
        MapperIoUtils.runProcesses(processBus, processReqs, 10000L);
        HashSet<InetAddress> potentialGatewayAddresses = new HashSet<InetAddress>();
        potentialGatewayAddresses.addAll(MapperIoUtils.PRESET_IPV4_GATEWAY_ADDRESSES);
        potentialGatewayAddresses.addAll(Arrays.asList(additionalIps));
        for (MapperIoUtils.ProcessRequest req : processReqs) {
            List<String> netstatOutputIpv4Addresses = TextUtils.findAllIpv4Addresses(req.getOutput());
            List<String> netstatOutputIpv6Addresses = TextUtils.findAllIpv6Addresses(req.getOutput());
            List<String> netstatErrorIpv4Addresses = TextUtils.findAllIpv4Addresses(req.getError());
            List<String> netstatErrorIpv6Addresses = TextUtils.findAllIpv6Addresses(req.getError());
            potentialGatewayAddresses.addAll(MapperIoUtils.convertToAddressSet(netstatOutputIpv4Addresses));
            potentialGatewayAddresses.addAll(MapperIoUtils.convertToAddressSet(netstatOutputIpv6Addresses));
            potentialGatewayAddresses.addAll(MapperIoUtils.convertToAddressSet(netstatErrorIpv4Addresses));
            potentialGatewayAddresses.addAll(MapperIoUtils.convertToAddressSet(netstatErrorIpv6Addresses));
        }
        Iterator pgaIt = potentialGatewayAddresses.iterator();
        while (pgaIt.hasNext()) {
            InetAddress address = (InetAddress)pgaIt.next();
            if (!address.isAnyLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress()) continue;
            pgaIt.remove();
        }
        LinkedList<MapperIoUtils.UdpRequest> udpReqs = new LinkedList<MapperIoUtils.UdpRequest>();
        Set<InetAddress> sourceAddresses = MapperIoUtils.getLocalIpAddresses(networkBus);
        for (InetAddress sourceAddress : sourceAddresses) {
            for (InetAddress gatewayAddress : potentialGatewayAddresses) {
                if (!sourceAddress.getClass().equals(gatewayAddress.getClass())) continue;
                MapperIoUtils.UdpRequest udpReq = new MapperIoUtils.UdpRequest(sourceAddress, new InetSocketAddress(gatewayAddress, 5351), new MapPcpRequest(new byte[12], 0, 0, 0, NetworkUtils.ZERO_IPV6, 0L, NetworkUtils.ZERO_IPV4, new PcpOption[0]), new MapperIoUtils.RequestToBytesTransformer(){

                    @Override
                    public byte[] create(Object request) {
                        return ((MapPcpRequest)request).dump();
                    }
                }, new MapperIoUtils.BytesToResponseTransformer(){

                    @Override
                    public Object create(byte[] buffer) {
                        if (buffer.length < 4 || buffer[0] != 2) {
                            throw new IllegalArgumentException();
                        }
                        MapPcpResponse resp = new MapPcpResponse(buffer);
                        return resp;
                    }
                });
                udpReqs.add(udpReq);
            }
        }
        MapperIoUtils.performUdpRequests(networkBus, udpReqs, false, 1000L, 1000L, 1000L, 1000L, 1000L);
        LinkedList<PcpPortMapper> mappers = new LinkedList<PcpPortMapper>();
        for (MapperIoUtils.UdpRequest udpReq : udpReqs) {
            if (udpReq.getResponse() == null) continue;
            PcpPortMapper portMapper = new PcpPortMapper(networkBus, udpReq.getSourceAddress(), udpReq.getDestinationSocketAddress().getAddress());
            mappers.add(portMapper);
        }
        return mappers;
    }

    public PcpPortMapper(Bus networkBus, InetAddress internalAddress, InetAddress gatewayAddress) {
        Validate.notNull(networkBus);
        Validate.notNull(internalAddress);
        Validate.notNull(gatewayAddress);
        this.random = new Random();
        this.networkBus = networkBus;
        this.internalAddress = internalAddress;
        this.gatewayAddress = gatewayAddress;
    }

    @Override
    public MappedPort mapPort(PortType portType, int internalPort, int externalPort, long lifetime) throws InterruptedException {
        LOG.info("Attempting to map {} Internal:{} External:{} Lifetime:{}", new Object[]{portType, internalPort, externalPort, lifetime});
        Validate.notNull(portType);
        Validate.inclusiveBetween(1L, 65535L, internalPort);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, lifetime);
        byte[] nonce = this.nextNonce();
        MapperIoUtils.UdpRequest mapIpReq = this.createMappingUdpRequest(nonce, portType, internalPort, externalPort, lifetime);
        MapperIoUtils.performUdpRequests(this.networkBus, Collections.singleton(mapIpReq), false, MapperIoUtils.calculateExponentialBackoffTimes(4));
        if (mapIpReq.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to mapping port");
        }
        MapPcpResponse mappingResp = (MapPcpResponse)mapIpReq.getResponse();
        PcpMappedPort mappedPort = new PcpMappedPort(nonce, mappingResp.getInternalPort(), mappingResp.getAssignedExternalPort(), mappingResp.getAssignedExternalIpAddress(), portType, mappingResp.getLifetime());
        LOG.debug("Map successful {}", (Object)mappedPort);
        return mappedPort;
    }

    @Override
    public void unmapPort(MappedPort mappedPort) throws InterruptedException {
        LOG.info("Attempting to unmap {}", (Object)mappedPort);
        Validate.notNull(mappedPort);
        Validate.isTrue(mappedPort instanceof PcpMappedPort);
        byte[] nonce = ((PcpMappedPort)mappedPort).getNonce();
        PortType portType = mappedPort.getPortType();
        int internalPort = mappedPort.getInternalPort();
        MapperIoUtils.UdpRequest mapIpReq = this.createMappingUdpRequest(nonce, portType, internalPort, 0, 0L);
        MapperIoUtils.performUdpRequests(this.networkBus, Collections.singleton(mapIpReq), false, MapperIoUtils.calculateExponentialBackoffTimes(4));
        if (mapIpReq.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to mapping port");
        }
        LOG.debug("Unmap successful {}", (Object)mappedPort);
    }

    @Override
    public MappedPort refreshPort(MappedPort mappedPort, long lifetime) throws InterruptedException {
        LOG.info("Attempting to refresh mapping {} for {}", (Object)mappedPort, (Object)lifetime);
        Validate.notNull(mappedPort);
        Validate.isTrue(mappedPort instanceof PcpMappedPort);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, lifetime);
        MappedPort newMappedPort = this.mapPort(mappedPort.getPortType(), mappedPort.getInternalPort(), mappedPort.getExternalPort(), lifetime);
        if (mappedPort.getExternalPort() != newMappedPort.getExternalPort() || !Objects.equals(mappedPort.getExternalAddress(), newMappedPort.getExternalAddress())) {
            LOG.warn("Failed refresh mapping {}: ", (Object)mappedPort, (Object)newMappedPort);
            try {
                this.unmapPort(newMappedPort);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            throw new IllegalStateException("External IP/port changed from " + mappedPort.getExternalAddress() + ":" + mappedPort.getExternalPort() + " to " + newMappedPort.getExternalAddress() + ":" + newMappedPort.getExternalPort());
        }
        LOG.debug("Mapping refreshed {}: ", (Object)mappedPort, (Object)newMappedPort);
        return newMappedPort;
    }

    private MapperIoUtils.UdpRequest createMappingUdpRequest(byte[] nonce, PortType portType, int internalPort, int externalPort, long lifetime) {
        MapperIoUtils.UdpRequest mapIpReq = new MapperIoUtils.UdpRequest(this.internalAddress, new InetSocketAddress(this.gatewayAddress, 5351), new MapPcpRequest(nonce, portType.getProtocolNumber(), internalPort, externalPort, NetworkUtils.ZERO_IPV6, lifetime, this.internalAddress, new PcpOption[0]), new MapperIoUtils.RequestToBytesTransformer(){

            @Override
            public byte[] create(Object request) {
                return ((MapPcpRequest)request).dump();
            }
        }, new MapperIoUtils.BytesToResponseTransformer(){

            @Override
            public Object create(byte[] buffer) {
                MapPcpResponse resp = new MapPcpResponse(buffer);
                if (resp.getResultCode() != PcpResultCode.SUCCESS.ordinal()) {
                    throw new IllegalArgumentException();
                }
                return resp;
            }
        });
        return mapIpReq;
    }

    @Override
    public InetAddress getSourceAddress() {
        return this.internalAddress;
    }

    private byte[] nextNonce() {
        byte[] mappingNonce = new byte[12];
        this.random.nextBytes(mappingNonce);
        return mappingNonce;
    }

    public String toString() {
        return "PcpPortMapper{networkBus=" + this.networkBus + ", internalAddress=" + this.internalAddress + ", gatewayAddress=" + this.gatewayAddress + ", random=" + this.random + '}';
    }
}

