/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.NetworkUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.InternalUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpOption;
import java.net.InetAddress;
import java.util.Objects;

public final class FilterPcpOption
extends PcpOption {
    private static final int OP_CODE = 3;
    private static final int DATA_LENGTH = 20;
    private int prefixLength;
    private int remotePeerPort;
    private InetAddress remotePeerIpAddress;

    public FilterPcpOption(byte[] buffer, int offset) {
        super(buffer, offset);
        Validate.isTrue(super.getCode() == 3);
        Validate.isTrue(super.getDataLength() == 20);
        offset += 4;
        this.prefixLength = buffer[++offset];
        Validate.inclusiveBetween(0L, 128L, this.prefixLength);
        this.remotePeerPort = InternalUtils.bytesToShort(buffer, ++offset) & 0xFFFF;
        Validate.inclusiveBetween(0L, 65535L, this.remotePeerPort);
        this.remotePeerIpAddress = NetworkUtils.convertBytesToAddress(buffer, offset += 2, 16);
        offset += 16;
    }

    public FilterPcpOption(int prefixLength, int remotePeerPort, InetAddress remotePeerIpAddress) {
        super(3, 20);
        Validate.inclusiveBetween(0L, 128L, prefixLength);
        Validate.inclusiveBetween(0L, 65535L, remotePeerPort);
        Validate.notNull(remotePeerIpAddress);
        this.prefixLength = prefixLength;
        this.remotePeerPort = remotePeerPort;
        this.remotePeerIpAddress = remotePeerIpAddress;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public int getRemotePeerPort() {
        return this.remotePeerPort;
    }

    public InetAddress getRemotePeerIpAddress() {
        return this.remotePeerIpAddress;
    }

    @Override
    public byte[] getData() {
        byte[] data = new byte[20];
        data[0] = 0;
        data[1] = (byte)this.prefixLength;
        InternalUtils.shortToBytes(data, 2, (short)this.remotePeerPort);
        byte[] ipv6AsBytes = NetworkUtils.convertAddressToIpv6Bytes(this.remotePeerIpAddress);
        Validate.validState(ipv6AsBytes.length == 16);
        System.arraycopy(ipv6AsBytes, 0, data, 4, ipv6AsBytes.length);
        return data;
    }

    @Override
    public String toString() {
        return "FilterPcpOption{super=" + super.toString() + "prefixLength=" + this.prefixLength + ", remotePeerPort=" + this.remotePeerPort + ", remotePeerIpAddress=" + this.remotePeerIpAddress + '}';
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + this.prefixLength;
        hash = 97 * hash + this.remotePeerPort;
        hash = 97 * hash + Objects.hashCode(this.remotePeerIpAddress);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterPcpOption other = (FilterPcpOption)obj;
        if (this.prefixLength != other.prefixLength) {
            return false;
        }
        if (this.remotePeerPort != other.remotePeerPort) {
            return false;
        }
        return Objects.equals(this.remotePeerIpAddress, other.remotePeerIpAddress);
    }
}

