/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.FilterPcpOption;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpOption;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PreferFailurePcpOption;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.ThirdPartyPcpOption;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.UnknownPcpOption;
import java.util.ArrayList;
import java.util.List;

final class InternalUtils {
    static final int PCP_VERSION = 2;
    static final int MAX_UDP_PAYLOAD = 1100;

    private InternalUtils() {
    }

    static long bytesToLong(byte[] data, int offset) {
        return ((long)data[offset + 0] & 0xFFL) << 56 | ((long)data[offset + 1] & 0xFFL) << 48 | ((long)data[offset + 2] & 0xFFL) << 40 | ((long)data[offset + 3] & 0xFFL) << 32 | ((long)data[offset + 4] & 0xFFL) << 24 | ((long)data[offset + 5] & 0xFFL) << 16 | ((long)data[offset + 6] & 0xFFL) << 8 | (long)data[offset + 7] & 0xFFL;
    }

    static void longToBytes(byte[] data, int offset, long value) {
        data[offset] = (byte)(value >> 56 & 0xFFL);
        data[offset + 1] = (byte)(value >> 48 & 0xFFL);
        data[offset + 2] = (byte)(value >> 40 & 0xFFL);
        data[offset + 3] = (byte)(value >> 32 & 0xFFL);
        data[offset + 4] = (byte)(value >> 24 & 0xFFL);
        data[offset + 5] = (byte)(value >> 16 & 0xFFL);
        data[offset + 6] = (byte)(value >> 8 & 0xFFL);
        data[offset + 7] = (byte)(value & 0xFFL);
    }

    static int bytesToInt(byte[] data, int offset) {
        return (data[offset + 0] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
    }

    static void intToBytes(byte[] data, int offset, int value) {
        data[offset] = (byte)(value >> 24 & 0xFF);
        data[offset + 1] = (byte)(value >> 16 & 0xFF);
        data[offset + 2] = (byte)(value >> 8 & 0xFF);
        data[offset + 3] = (byte)(value & 0xFF);
    }

    static short bytesToShort(byte[] data, int offset) {
        return (short)((data[offset + 0] & 0xFF) << 8 | data[offset + 1] & 0xFF);
    }

    static void shortToBytes(byte[] data, int offset, short value) {
        data[offset] = (byte)(value >> 8 & 0xFF);
        data[offset + 1] = (byte)(value & 0xFF);
    }

    static List<PcpOption> parseOptions(byte[] buffer, int offset) {
        Validate.notNull(buffer);
        Validate.isTrue(offset >= 0);
        Validate.isTrue(offset <= buffer.length);
        ArrayList<PcpOption> pcpOptionsList = new ArrayList<PcpOption>();
        while (offset < buffer.length) {
            PcpOption option;
            try {
                option = new FilterPcpOption(buffer, offset);
                offset += option.getBufferLength();
                pcpOptionsList.add(option);
            }
            catch (IllegalArgumentException iae) {
                try {
                    option = new PreferFailurePcpOption(buffer, offset);
                    offset += option.getBufferLength();
                    pcpOptionsList.add(option);
                }
                catch (IllegalArgumentException iae2) {
                    try {
                        option = new ThirdPartyPcpOption(buffer, offset);
                        offset += option.getBufferLength();
                        pcpOptionsList.add(option);
                    }
                    catch (IllegalArgumentException iae3) {
                        option = new UnknownPcpOption(buffer, offset);
                        offset += option.getBufferLength();
                        pcpOptionsList.add(option);
                    }
                }
            }
        }
        return pcpOptionsList;
    }
}

