/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.InternalUtils;

public abstract class PcpOption {
    protected static final int HEADER_LENGTH = 4;
    protected static final int DATA_PADDING_LIMIT = 4;
    private int code;
    private int dataLength;

    public PcpOption(byte[] buffer, int offset) {
        Validate.notNull(buffer);
        Validate.isTrue(offset >= 0);
        int remainingLength = buffer.length - offset;
        Validate.isTrue(remainingLength >= 4);
        this.code = buffer[offset] & 0xFF;
        ++offset;
        int dataLength = InternalUtils.bytesToShort(buffer, ++offset) & 0xFFFF;
        Validate.isTrue(dataLength <= 65535);
        this.dataLength = dataLength;
        offset += 2;
        int expectedPadding = dataLength % 4;
        int expectedLength = 4 + dataLength + expectedPadding;
        Validate.isTrue(remainingLength >= expectedLength);
    }

    public PcpOption(int code, int dataLength) {
        Validate.inclusiveBetween(0L, 255L, code);
        Validate.isTrue(dataLength <= 65535);
        this.code = code;
        this.dataLength = dataLength;
    }

    public final int getCode() {
        return this.code;
    }

    public final int getDataLength() {
        return this.dataLength;
    }

    public abstract byte[] getData();

    public final int getBufferLength() {
        int padding = this.dataLength % 4;
        int length = 4 + this.dataLength + padding;
        return length;
    }

    public final byte[] dump() {
        byte[] data = this.getData();
        int bufferLength = this.getBufferLength();
        byte[] buffer = new byte[bufferLength];
        buffer[0] = (byte)this.code;
        buffer[1] = 0;
        InternalUtils.shortToBytes(buffer, 2, (short)data.length);
        System.arraycopy(data, 0, buffer, 4, data.length);
        return buffer;
    }

    public String toString() {
        return "PcpOption{code=" + this.code + ", dataLength=" + this.dataLength + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.code;
        hash = 89 * hash + this.dataLength;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PcpOption other = (PcpOption)obj;
        if (this.code != other.code) {
            return false;
        }
        return this.dataLength == other.dataLength;
    }
}

