/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.NetworkUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.InternalUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpMessage;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpOption;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class PcpRequest
implements PcpMessage {
    protected static final int HEADER_LENGTH = 24;
    private int op;
    private long lifetime;
    private InetAddress internalIp;
    private List<PcpOption> options;
    private int dataLength;
    private int optionsLength;

    public PcpRequest(int op, long lifetime, InetAddress internalIp, int opcodeSpecificDataLength, PcpOption ... options) {
        Validate.notNull(internalIp);
        Validate.noNullElements(options);
        this.op = op;
        this.lifetime = lifetime;
        this.internalIp = internalIp;
        this.options = Collections.unmodifiableList(new ArrayList<PcpOption>(Arrays.asList(options)));
        this.dataLength = opcodeSpecificDataLength;
        for (PcpOption option : options) {
            this.optionsLength += option.getDataLength();
        }
        this.validateState();
    }

    public PcpRequest(byte[] buffer, int opcodeSpecificDataLength) {
        Validate.notNull(buffer);
        Validate.isTrue(opcodeSpecificDataLength >= 0);
        Validate.isTrue(buffer.length >= 24);
        int offset = 0;
        int version = buffer[offset] & 0xFF;
        Validate.isTrue(version == 2);
        int temp = buffer[++offset] & 0xFF;
        Validate.isTrue((temp & 0x80) == 0);
        this.op = temp;
        ++offset;
        this.lifetime = (long)InternalUtils.bytesToInt(buffer, offset += 2) & 0xFFFFFFFFL;
        this.internalIp = NetworkUtils.convertBytesToAddress(buffer, offset += 4, 16);
        offset += 16;
        this.dataLength = opcodeSpecificDataLength;
        this.options = InternalUtils.parseOptions(buffer, offset += opcodeSpecificDataLength);
        for (PcpOption option : this.options) {
            this.optionsLength += option.getDataLength();
        }
        this.validateState();
    }

    private void validateState() {
        Validate.notNull(this.internalIp);
        Validate.inclusiveBetween(0L, 127L, this.op);
        Validate.inclusiveBetween(0L, 0xFFFFFFFFL, this.lifetime);
        Validate.isTrue(this.dataLength >= 0);
        Validate.isTrue(this.optionsLength >= 0);
        Validate.noNullElements(this.options);
    }

    public final int getOp() {
        return this.op;
    }

    public final long getLifetime() {
        return this.lifetime;
    }

    public final InetAddress getInternalIp() {
        return this.internalIp;
    }

    public final List<PcpOption> getOptions() {
        return this.options;
    }

    public final int getDataLength() {
        return this.dataLength;
    }

    public abstract byte[] getData();

    public final int getBufferLength() {
        int length = 24 + this.dataLength + this.optionsLength;
        return length;
    }

    @Override
    public final byte[] dump() {
        int payloadLength = 24;
        byte[] opcodeSpecificData = this.getData();
        payloadLength += opcodeSpecificData.length;
        ArrayList<byte[]> optionsData = new ArrayList<byte[]>(this.options.size());
        for (PcpOption option : this.options) {
            byte[] optionData = option.dump();
            payloadLength += optionData.length;
            optionsData.add(optionData);
        }
        Validate.isTrue(payloadLength <= 1100);
        byte[] data = new byte[payloadLength];
        data[0] = 2;
        data[1] = (byte)this.op;
        InternalUtils.shortToBytes(data, 2, (short)0);
        InternalUtils.intToBytes(data, 4, (int)this.lifetime);
        byte[] selfAddressArr = NetworkUtils.convertAddressToIpv6Bytes(this.internalIp);
        System.arraycopy(selfAddressArr, 0, data, 8, selfAddressArr.length);
        int offset = 24;
        System.arraycopy(opcodeSpecificData, 0, data, offset, opcodeSpecificData.length);
        offset += opcodeSpecificData.length;
        for (byte[] optionData : optionsData) {
            System.arraycopy(optionData, 0, data, offset, optionData.length);
            offset += optionData.length;
        }
        return data;
    }

    public String toString() {
        return "PcpRequest{op=" + this.op + ", lifetime=" + this.lifetime + ", internalIp=" + this.internalIp + ", options=" + this.options + ", dataLength=" + this.dataLength + ", optionsLength=" + this.optionsLength + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.op;
        hash = 97 * hash + (int)(this.lifetime ^ this.lifetime >>> 32);
        hash = 97 * hash + Objects.hashCode(this.internalIp);
        hash = 97 * hash + Objects.hashCode(this.options);
        hash = 97 * hash + this.dataLength;
        hash = 97 * hash + this.optionsLength;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PcpRequest other = (PcpRequest)obj;
        if (this.op != other.op) {
            return false;
        }
        if (this.lifetime != other.lifetime) {
            return false;
        }
        if (this.dataLength != other.dataLength) {
            return false;
        }
        if (this.optionsLength != other.optionsLength) {
            return false;
        }
        if (!Objects.equals(this.internalIp, other.internalIp)) {
            return false;
        }
        return Objects.equals(this.options, other.options);
    }
}

