/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.InternalUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpMessage;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class PcpResponse
implements PcpMessage {
    protected static final int HEADER_LENGTH = 24;
    private int op;
    private int resultCode;
    private long lifetime;
    private long epochTime;
    private List<PcpOption> options;
    private int dataLength;
    private int optionsLength;

    public PcpResponse(int op, int resultCode, long lifetime, long epochTime, int opcodeSpecificDataLength, PcpOption ... options) {
        Validate.noNullElements(options);
        this.op = op;
        this.resultCode = resultCode;
        this.lifetime = lifetime;
        this.epochTime = epochTime;
        this.options = Collections.unmodifiableList(new ArrayList<PcpOption>(Arrays.asList(options)));
        this.dataLength = opcodeSpecificDataLength;
        this.dataLength = opcodeSpecificDataLength;
        for (PcpOption option : options) {
            this.optionsLength += option.getDataLength();
        }
        this.validateState();
    }

    public PcpResponse(byte[] buffer, int opcodeSpecificDataLength) {
        Validate.notNull(buffer);
        Validate.isTrue(opcodeSpecificDataLength >= 0);
        Validate.isTrue(buffer.length >= 24);
        int offset = 0;
        int version = buffer[offset] & 0xFF;
        Validate.isTrue(version == 2);
        int temp = buffer[++offset] & 0xFF;
        Validate.isTrue((temp & 0x80) == 128);
        this.op = temp & 0x7F;
        ++offset;
        this.resultCode = buffer[++offset] & 0xFF;
        this.lifetime = (long)InternalUtils.bytesToInt(buffer, ++offset) & 0xFFFFFFFFL;
        this.epochTime = (long)InternalUtils.bytesToInt(buffer, offset += 4) & 0xFFFFFFFFL;
        offset += 4;
        offset += 12;
        this.dataLength = opcodeSpecificDataLength;
        this.options = InternalUtils.parseOptions(buffer, offset += opcodeSpecificDataLength);
        for (PcpOption option : this.options) {
            this.optionsLength += option.getDataLength();
        }
    }

    private void validateState() {
        Validate.inclusiveBetween(0L, 127L, this.op);
        Validate.inclusiveBetween(0L, 255L, this.resultCode);
        Validate.inclusiveBetween(0L, 0xFFFFFFFFL, this.lifetime);
        Validate.inclusiveBetween(0L, 0xFFFFFFFFL, this.epochTime);
        Validate.isTrue(this.dataLength >= 0);
        Validate.isTrue(this.optionsLength >= 0);
        Validate.noNullElements(this.options);
    }

    public final int getOp() {
        return this.op;
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public final long getLifetime() {
        return this.lifetime;
    }

    public final long getEpochTime() {
        return this.epochTime;
    }

    public final List<PcpOption> getOptions() {
        return this.options;
    }

    public final int getDataLength() {
        return this.dataLength;
    }

    public abstract byte[] getData();

    public final int getBufferLength() {
        int length = 24 + this.dataLength + this.optionsLength;
        return length;
    }

    @Override
    public final byte[] dump() {
        int payloadLength = 24;
        byte[] opcodeSpecificData = this.getData();
        payloadLength += opcodeSpecificData.length;
        ArrayList<byte[]> optionsData = new ArrayList<byte[]>(this.options.size());
        for (PcpOption option : this.options) {
            byte[] optionData = option.dump();
            payloadLength += optionData.length;
            optionsData.add(optionData);
        }
        Validate.isTrue(payloadLength <= 1100);
        byte[] data = new byte[payloadLength];
        data[0] = 2;
        data[1] = (byte)(this.op | 0x80);
        data[2] = 0;
        data[3] = (byte)this.resultCode;
        InternalUtils.intToBytes(data, 4, (int)this.lifetime);
        InternalUtils.intToBytes(data, 8, (int)this.epochTime);
        int offset = 24;
        System.arraycopy(opcodeSpecificData, 0, data, offset, opcodeSpecificData.length);
        offset += opcodeSpecificData.length;
        for (byte[] optionData : optionsData) {
            System.arraycopy(optionData, 0, data, offset, optionData.length);
            offset += optionData.length;
        }
        return data;
    }

    public String toString() {
        return "PcpResponse{op=" + this.op + ", resultCode=" + this.resultCode + ", lifetime=" + this.lifetime + ", epochTime=" + this.epochTime + ", options=" + this.options + ", dataLength=" + this.dataLength + ", optionsLength=" + this.optionsLength + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.op;
        hash = 67 * hash + this.resultCode;
        hash = 67 * hash + (int)(this.lifetime ^ this.lifetime >>> 32);
        hash = 67 * hash + (int)(this.epochTime ^ this.epochTime >>> 32);
        hash = 67 * hash + Objects.hashCode(this.options);
        hash = 67 * hash + this.dataLength;
        hash = 67 * hash + this.optionsLength;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PcpResponse other = (PcpResponse)obj;
        if (this.op != other.op) {
            return false;
        }
        if (this.resultCode != other.resultCode) {
            return false;
        }
        if (this.lifetime != other.lifetime) {
            return false;
        }
        if (this.epochTime != other.epochTime) {
            return false;
        }
        if (this.dataLength != other.dataLength) {
            return false;
        }
        if (this.optionsLength != other.optionsLength) {
            return false;
        }
        return Objects.equals(this.options, other.options);
    }
}

