/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.NetworkUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.InternalUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpOption;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpResponse;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Objects;

public final class PeerPcpResponse
extends PcpResponse {
    private static final int OPCODE = 2;
    private static final int DATA_LENGTH = 56;
    private static final int NONCE_LENGTH = 12;
    private byte[] mappingNonce;
    private int protocol;
    private int internalPort;
    private int assignedExternalPort;
    private InetAddress assignedExternalIpAddress;
    private int remotePeerPort;
    private InetAddress remotePeerIpAddress;

    public PeerPcpResponse(byte[] mappingNonce, int protocol, int internalPort, int assignedExternalPort, InetAddress assignedExternalIpAddress, int remotePeerPort, InetAddress remotePeerIpAddress, int resultCode, long lifetime, long epochTime, PcpOption ... options) {
        super(2, resultCode, lifetime, epochTime, 56, options);
        Validate.notNull(mappingNonce);
        Validate.notNull(assignedExternalIpAddress);
        Validate.notNull(remotePeerIpAddress);
        this.mappingNonce = Arrays.copyOf(mappingNonce, mappingNonce.length);
        this.protocol = protocol;
        this.internalPort = internalPort;
        this.assignedExternalPort = assignedExternalPort;
        this.assignedExternalIpAddress = assignedExternalIpAddress;
        this.remotePeerPort = remotePeerPort;
        this.remotePeerIpAddress = remotePeerIpAddress;
        this.validateState();
    }

    public PeerPcpResponse(byte[] buffer) {
        super(buffer, 56);
        Validate.isTrue(super.getOp() == 2);
        int remainingLength = buffer.length - 24;
        Validate.isTrue(remainingLength >= 56);
        int offset = 24;
        this.mappingNonce = new byte[12];
        System.arraycopy(buffer, offset, this.mappingNonce, 0, this.mappingNonce.length);
        this.protocol = buffer[offset += this.mappingNonce.length] & 0xFF;
        ++offset;
        this.internalPort = InternalUtils.bytesToShort(buffer, offset += 3) & 0xFFFF;
        this.assignedExternalPort = InternalUtils.bytesToShort(buffer, offset += 2) & 0xFFFF;
        this.assignedExternalIpAddress = NetworkUtils.convertBytesToAddress(buffer, offset += 2, 16);
        this.remotePeerPort = InternalUtils.bytesToShort(buffer, offset += 16) & 0xFFFF;
        offset += 2;
        this.remotePeerIpAddress = NetworkUtils.convertBytesToAddress(buffer, offset += 2, 16);
        offset += 16;
        this.validateState();
    }

    private void validateState() {
        Validate.notNull(this.mappingNonce);
        Validate.isTrue(this.mappingNonce.length == 12);
        Validate.inclusiveBetween(1L, 255L, this.protocol);
        Validate.inclusiveBetween(1L, 65535L, this.internalPort);
        if (this.getResultCode() == 0) {
            Validate.inclusiveBetween(1L, 65535L, this.assignedExternalPort);
        } else {
            Validate.inclusiveBetween(0L, 65535L, this.assignedExternalPort);
        }
        Validate.notNull(this.assignedExternalIpAddress);
        Validate.inclusiveBetween(1L, 65535L, this.remotePeerPort);
        Validate.notNull(this.remotePeerIpAddress);
    }

    @Override
    public byte[] getData() {
        byte[] data = new byte[56];
        int offset = 0;
        System.arraycopy(this.mappingNonce, 0, data, offset, this.mappingNonce.length);
        data[offset += this.mappingNonce.length] = (byte)this.protocol;
        ++offset;
        InternalUtils.shortToBytes(data, offset += 3, (short)this.internalPort);
        InternalUtils.shortToBytes(data, offset += 2, (short)this.assignedExternalPort);
        byte[] ipv6Array = NetworkUtils.convertAddressToIpv6Bytes(this.assignedExternalIpAddress);
        System.arraycopy(ipv6Array, 0, data, offset += 2, ipv6Array.length);
        InternalUtils.shortToBytes(data, offset += ipv6Array.length, (short)this.remotePeerPort);
        offset += 2;
        ipv6Array = NetworkUtils.convertAddressToIpv6Bytes(this.remotePeerIpAddress);
        System.arraycopy(ipv6Array, 0, data, offset += 2, ipv6Array.length);
        offset += ipv6Array.length;
        return data;
    }

    public byte[] getMappingNonce() {
        return Arrays.copyOf(this.mappingNonce, this.mappingNonce.length);
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public int getAssignedExternalPort() {
        return this.assignedExternalPort;
    }

    public InetAddress getAssignedExternalIpAddress() {
        return this.assignedExternalIpAddress;
    }

    public int getRemotePeerPort() {
        return this.remotePeerPort;
    }

    public InetAddress getRemotePeerIpAddress() {
        return this.remotePeerIpAddress;
    }

    @Override
    public String toString() {
        return "PeerPcpResponse{super=" + super.toString() + "mappingNonce=" + Arrays.toString(this.mappingNonce) + ", protocol=" + this.protocol + ", internalPort=" + this.internalPort + ", assignedExternalPort=" + this.assignedExternalPort + ", assignedExternalIpAddress=" + this.assignedExternalIpAddress + ", remotePeerPort=" + this.remotePeerPort + ", remotePeerIpAddress=" + this.remotePeerIpAddress + '}';
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 17 * hash + Arrays.hashCode(this.mappingNonce);
        hash = 17 * hash + this.protocol;
        hash = 17 * hash + this.internalPort;
        hash = 17 * hash + this.assignedExternalPort;
        hash = 17 * hash + Objects.hashCode(this.assignedExternalIpAddress);
        hash = 17 * hash + this.remotePeerPort;
        hash = 17 * hash + Objects.hashCode(this.remotePeerIpAddress);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerPcpResponse other = (PeerPcpResponse)obj;
        if (this.protocol != other.protocol) {
            return false;
        }
        if (this.internalPort != other.internalPort) {
            return false;
        }
        if (this.assignedExternalPort != other.assignedExternalPort) {
            return false;
        }
        if (this.remotePeerPort != other.remotePeerPort) {
            return false;
        }
        if (!Arrays.equals(this.mappingNonce, other.mappingNonce)) {
            return false;
        }
        if (!Objects.equals(this.assignedExternalIpAddress, other.assignedExternalIpAddress)) {
            return false;
        }
        return Objects.equals(this.remotePeerIpAddress, other.remotePeerIpAddress);
    }
}

