/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.NetworkUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.pcp.externalmessages.PcpOption;
import java.net.InetAddress;
import java.util.Objects;

public final class ThirdPartyPcpOption
extends PcpOption {
    private static final int OP_CODE = 1;
    private static final int DATA_LENGTH = 16;
    private InetAddress internalIpAddress;

    public ThirdPartyPcpOption(byte[] buffer, int offset) {
        super(buffer, offset);
        Validate.isTrue(super.getCode() == 1);
        Validate.isTrue(super.getDataLength() == 16);
        this.internalIpAddress = NetworkUtils.convertBytesToAddress(buffer, offset += 4, 16);
        offset += 16;
    }

    public ThirdPartyPcpOption(InetAddress internalIpAddress) {
        super(1, 16);
        Validate.notNull(internalIpAddress);
        this.internalIpAddress = internalIpAddress;
    }

    public InetAddress getInternalIpAddress() {
        return this.internalIpAddress;
    }

    @Override
    public byte[] getData() {
        byte[] data = new byte[16];
        byte[] ipv6AsBytes = NetworkUtils.convertAddressToIpv6Bytes(this.internalIpAddress);
        Validate.validState(ipv6AsBytes.length == 16);
        System.arraycopy(ipv6AsBytes, 0, data, 0, ipv6AsBytes.length);
        return data;
    }

    @Override
    public String toString() {
        return "ThirdPartyPcpOption{super=" + super.toString() + "internalIpAddress=" + this.internalIpAddress + '}';
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 23 * hash + Objects.hashCode(this.internalIpAddress);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThirdPartyPcpOption other = (ThirdPartyPcpOption)obj;
        return Objects.equals(this.internalIpAddress, other.internalIpAddress);
    }
}

