/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import java.net.InetAddress;

final class FirewallMappedPort
implements MappedPort {
    private String key;
    private int internalPort;
    private int externalPort;
    private PortType portType;
    private long lifetime;

    FirewallMappedPort(String key, int internalPort, int externalPort, PortType portType, long duration) {
        Validate.notNull(key);
        Validate.inclusiveBetween(1L, 65535L, internalPort);
        Validate.inclusiveBetween(1L, 65535L, externalPort);
        Validate.notNull(portType);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, duration);
        this.key = key;
        this.internalPort = internalPort;
        this.externalPort = externalPort;
        this.portType = portType;
        this.lifetime = duration;
    }

    String getKey() {
        return this.key;
    }

    @Override
    public int getInternalPort() {
        return this.internalPort;
    }

    @Override
    public int getExternalPort() {
        return this.externalPort;
    }

    @Override
    public InetAddress getExternalAddress() {
        return null;
    }

    @Override
    public PortType getPortType() {
        return this.portType;
    }

    @Override
    public long getLifetime() {
        return this.lifetime;
    }

    public String toString() {
        return "FirewallMappedPort{key=" + this.key + ", internalPort=" + this.internalPort + ", externalPort=" + this.externalPort + ", portType=" + (Object)((Object)this.portType) + ", lifetime=" + this.lifetime + '}';
    }
}

