/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd;

import com.v14d4n.opentoonline.relocated.commons.lang3.RandomUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.Range;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MapperIoUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.FirewallMappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.UpnpIgdPortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.AddPinholeUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.AddPinholeUpnpIgdResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.DeletePinholeUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.DeletePinholeUpnpIgdResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpdatePinholeUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpdatePinholeUpnpIgdResponse;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FirewallUpnpIgdPortMapper
extends UpnpIgdPortMapper {
    private static final Logger LOG = LoggerFactory.getLogger(FirewallUpnpIgdPortMapper.class);
    private final InetSocketAddress controlUrlAddress;

    public FirewallUpnpIgdPortMapper(Bus networkBus, InetAddress internalAddress, URL controlUrl, String serverName, String serviceType, Range<Long> externalPortRange, Range<Long> leaseDurationRange) {
        super(networkBus, internalAddress, controlUrl, serverName, serviceType, externalPortRange, leaseDurationRange);
        this.controlUrlAddress = FirewallUpnpIgdPortMapper.getAddressFromUrl(controlUrl);
    }

    @Override
    public MappedPort mapPort(PortType portType, int internalPort, int externalPort, long lifetime) throws InterruptedException {
        LOG.info("Attempting to map {} Internal:{} External:{} Lifetime:{}", new Object[]{portType, internalPort, externalPort, lifetime});
        Validate.notNull(portType);
        Validate.inclusiveBetween(1L, 65535L, internalPort);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, lifetime);
        Bus networkBus = this.getNetworkBus();
        URL controlUrl = this.getControlUrl();
        String serviceType = this.getServiceType();
        InetAddress internalAddress = this.getInternalAddress();
        long[] retryDurations = new long[]{5000L, 5000L, 5000L};
        for (int i = 0; i < 5; ++i) {
            Range<Long> externalPortRange = this.getExternalPortRange();
            Range<Long> leaseDurationRange = this.getLeaseDurationRange();
            long leaseDuration = leaseDurationRange.isBefore(lifetime) ? leaseDurationRange.getMaximum() : (leaseDurationRange.isAfter(lifetime) ? leaseDurationRange.getMinimum() : lifetime);
            Validate.validState(externalPortRange.contains(Long.valueOf(externalPort)), "Router reports external port mappings as %s", externalPortRange);
            MapperIoUtils.TcpRequest mapHttpRequest = new MapperIoUtils.TcpRequest(internalAddress, this.controlUrlAddress, new AddPinholeUpnpIgdRequest(controlUrl.getAuthority(), controlUrl.getFile(), serviceType, null, externalPort, internalAddress, internalPort, portType, leaseDuration), new UpnpIgdPortMapper.BasicRequestTransformer(), new MapperIoUtils.BytesToResponseTransformer(){

                @Override
                public Object create(byte[] buffer) {
                    return new AddPinholeUpnpIgdResponse(buffer);
                }
            });
            MapperIoUtils.performTcpRequests(networkBus, Collections.singleton(mapHttpRequest), retryDurations);
            if (mapHttpRequest.getResponse() != null) {
                String key = ((AddPinholeUpnpIgdResponse)mapHttpRequest.getResponse()).getUniqueId();
                FirewallMappedPort mappedPort = new FirewallMappedPort(key, internalPort, externalPort, portType, leaseDuration);
                LOG.debug("Map successful {}", (Object)mappedPort);
                return mappedPort;
            }
            retryDurations = new long[]{5000L};
            externalPort = RandomUtils.nextInt(externalPortRange.getMinimum().intValue(), externalPortRange.getMaximum().intValue() + 1);
        }
        throw new IllegalStateException();
    }

    @Override
    public void unmapPort(MappedPort mappedPort) throws InterruptedException {
        LOG.info("Attempting to unmap {}", (Object)mappedPort);
        Validate.notNull(mappedPort);
        Validate.isTrue(mappedPort instanceof FirewallMappedPort);
        Bus networkBus = this.getNetworkBus();
        URL controlUrl = this.getControlUrl();
        String serviceType = this.getServiceType();
        String key = ((FirewallMappedPort)mappedPort).getKey();
        InetAddress internalAddress = this.getInternalAddress();
        MapperIoUtils.TcpRequest httpRequest = new MapperIoUtils.TcpRequest(internalAddress, this.controlUrlAddress, new DeletePinholeUpnpIgdRequest(controlUrl.getAuthority(), controlUrl.getFile(), serviceType, key), new UpnpIgdPortMapper.BasicRequestTransformer(), new MapperIoUtils.BytesToResponseTransformer(){

            @Override
            public Object create(byte[] buffer) {
                return new DeletePinholeUpnpIgdResponse(buffer);
            }
        });
        MapperIoUtils.performTcpRequests(networkBus, Collections.singleton(httpRequest), 5000L, 5000L, 5000L);
        if (httpRequest.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to unmapping");
        }
        LOG.debug("Unmap successful {}", (Object)mappedPort);
    }

    @Override
    public MappedPort refreshPort(MappedPort mappedPort, long lifetime) throws InterruptedException {
        LOG.info("Attempting to refresh mapping {} for {}", (Object)mappedPort, (Object)lifetime);
        Validate.notNull(mappedPort);
        Validate.isTrue(mappedPort instanceof FirewallMappedPort);
        Bus networkBus = this.getNetworkBus();
        URL controlUrl = this.getControlUrl();
        String serviceType = this.getServiceType();
        Range<Long> leaseDurationRange = this.getLeaseDurationRange();
        long leaseDuration = leaseDurationRange.isBefore(lifetime) ? leaseDurationRange.getMaximum() : (leaseDurationRange.isAfter(lifetime) ? leaseDurationRange.getMinimum() : lifetime);
        String key = ((FirewallMappedPort)mappedPort).getKey();
        InetAddress internalAddress = this.getInternalAddress();
        MapperIoUtils.TcpRequest httpRequest = new MapperIoUtils.TcpRequest(internalAddress, this.controlUrlAddress, new UpdatePinholeUpnpIgdRequest(controlUrl.getAuthority(), controlUrl.getFile(), serviceType, key, leaseDuration), new UpnpIgdPortMapper.BasicRequestTransformer(), new MapperIoUtils.BytesToResponseTransformer(){

            @Override
            public Object create(byte[] buffer) {
                return new UpdatePinholeUpnpIgdResponse(buffer);
            }
        });
        MapperIoUtils.performTcpRequests(networkBus, Collections.singleton(httpRequest), 5000L, 5000L, 5000L);
        if (httpRequest.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to refresh");
        }
        FirewallMappedPort newMappedPort = new FirewallMappedPort(key, mappedPort.getInternalPort(), mappedPort.getExternalPort(), mappedPort.getPortType(), leaseDuration);
        LOG.warn("Mapping refreshed {}: ", (Object)mappedPort, (Object)newMappedPort);
        return newMappedPort;
    }

    @Override
    public String toString() {
        return "FirewallUpnpIgdPortMapper{super=" + super.toString() + '}';
    }
}

