/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd;

import com.v14d4n.opentoonline.relocated.commons.lang3.RandomUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.Range;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MapperIoUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.PortMapperMappedPort;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.UpnpIgdPortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.AddAnyPortMappingUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.AddAnyPortMappingUpnpIgdResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.AddPortMappingUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.AddPortMappingUpnpIgdResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.DeletePortMappingUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.DeletePortMappingUpnpIgdResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.GetExternalIpAddressUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.GetExternalIpAddressUpnpIgdResponse;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PortMapperUpnpIgdPortMapper
extends UpnpIgdPortMapper {
    private static final Logger LOG = LoggerFactory.getLogger(PortMapperUpnpIgdPortMapper.class);
    private final InetSocketAddress controlUrlAddress;
    private final boolean hasAddAnyPortMappingMethod;

    public PortMapperUpnpIgdPortMapper(Bus networkBus, InetAddress internalAddress, URL controlUrl, String serverName, String serviceType, Range<Long> externalPortRange, Range<Long> leaseDurationRange, boolean hasAddAnyPortMappingMethod) {
        super(networkBus, internalAddress, controlUrl, serverName, serviceType, externalPortRange, leaseDurationRange);
        this.controlUrlAddress = PortMapperUpnpIgdPortMapper.getAddressFromUrl(controlUrl);
        this.hasAddAnyPortMappingMethod = hasAddAnyPortMappingMethod;
    }

    @Override
    public MappedPort mapPort(PortType portType, int internalPort, int externalPort, long lifetime) throws InterruptedException {
        LOG.info("Attempting to map {} Internal:{} External:{} Lifetime:{}", new Object[]{portType, internalPort, externalPort, lifetime});
        Validate.notNull(portType);
        Validate.inclusiveBetween(1L, 65535L, internalPort);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, lifetime);
        Bus networkBus = this.getNetworkBus();
        URL controlUrl = this.getControlUrl();
        String serviceType = this.getServiceType();
        InetAddress internalAddress = this.getInternalAddress();
        MapperIoUtils.TcpRequest externalIpHttpRequest = new MapperIoUtils.TcpRequest(internalAddress, this.controlUrlAddress, new GetExternalIpAddressUpnpIgdRequest(controlUrl.getAuthority(), controlUrl.getFile(), serviceType), new UpnpIgdPortMapper.BasicRequestTransformer(), new MapperIoUtils.BytesToResponseTransformer(){

            @Override
            public Object create(byte[] buffer) {
                return new GetExternalIpAddressUpnpIgdResponse(buffer);
            }
        });
        MapperIoUtils.performTcpRequests(networkBus, Collections.singleton(externalIpHttpRequest), 5000L, 5000L, 5000L);
        if (externalIpHttpRequest.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to getting external IP");
        }
        InetAddress externalAddress = ((GetExternalIpAddressUpnpIgdResponse)externalIpHttpRequest.getResponse()).getIpAddress();
        MappedPort mappedPort = this.hasAddAnyPortMappingMethod ? this.newMapPort(portType, internalPort, externalPort, lifetime, externalAddress) : this.oldMapPort(portType, internalPort, externalPort, lifetime, externalAddress);
        LOG.debug("Map successful {}", (Object)mappedPort);
        return mappedPort;
    }

    private MappedPort newMapPort(PortType portType, int internalPort, int externalPort, long lifetime, InetAddress externalAddress) throws InterruptedException {
        Bus networkBus = this.getNetworkBus();
        URL controlUrl = this.getControlUrl();
        String serviceType = this.getServiceType();
        InetAddress internalAddress = this.getInternalAddress();
        Range<Long> externalPortRange = this.getExternalPortRange();
        Range<Long> leaseDurationRange = this.getLeaseDurationRange();
        long leaseDuration = leaseDurationRange.isBefore(lifetime) ? leaseDurationRange.getMaximum() : (leaseDurationRange.isAfter(lifetime) ? leaseDurationRange.getMinimum() : lifetime);
        Validate.validState(externalPortRange.contains(Long.valueOf(externalPort)), "Router reports external port mappings as %s", externalPortRange);
        MapperIoUtils.TcpRequest mapHttpRequest = new MapperIoUtils.TcpRequest(internalAddress, this.controlUrlAddress, new AddAnyPortMappingUpnpIgdRequest(controlUrl.getAuthority(), controlUrl.getFile(), serviceType, null, externalPort, portType, internalPort, internalAddress, true, "", leaseDuration), new UpnpIgdPortMapper.BasicRequestTransformer(), new MapperIoUtils.BytesToResponseTransformer(){

            @Override
            public Object create(byte[] buffer) {
                return new AddAnyPortMappingUpnpIgdResponse(buffer);
            }
        });
        MapperIoUtils.performTcpRequests(networkBus, Collections.singleton(mapHttpRequest), 5000L, 5000L, 5000L);
        if (mapHttpRequest.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to mapping");
        }
        int reservedExternalPort = ((AddAnyPortMappingUpnpIgdResponse)mapHttpRequest.getResponse()).getReservedPort();
        return new PortMapperMappedPort(internalPort, reservedExternalPort, externalAddress, portType, leaseDuration);
    }

    private MappedPort oldMapPort(PortType portType, int internalPort, int externalPort, long lifetime, InetAddress externalAddress) throws InterruptedException {
        Bus networkBus = this.getNetworkBus();
        URL controlUrl = this.getControlUrl();
        String serviceType = this.getServiceType();
        InetAddress internalAddress = this.getInternalAddress();
        long[] retryDurations = new long[]{5000L, 5000L, 5000L};
        for (int i = 0; i < 5; ++i) {
            Range<Long> externalPortRange = this.getExternalPortRange();
            Range<Long> leaseDurationRange = this.getLeaseDurationRange();
            long leaseDuration = leaseDurationRange.isBefore(lifetime) ? leaseDurationRange.getMaximum() : (leaseDurationRange.isAfter(lifetime) ? leaseDurationRange.getMinimum() : lifetime);
            Validate.validState(externalPortRange.contains(Long.valueOf(externalPort)), "Router reports external port mappings as %s", externalPortRange);
            MapperIoUtils.TcpRequest mapHttpRequest = new MapperIoUtils.TcpRequest(internalAddress, this.controlUrlAddress, new AddPortMappingUpnpIgdRequest(controlUrl.getAuthority(), controlUrl.getFile(), serviceType, null, externalPort, portType, internalPort, internalAddress, true, "", leaseDuration), new UpnpIgdPortMapper.BasicRequestTransformer(), new MapperIoUtils.BytesToResponseTransformer(){

                @Override
                public Object create(byte[] buffer) {
                    return new AddPortMappingUpnpIgdResponse(buffer);
                }
            });
            MapperIoUtils.performTcpRequests(networkBus, Collections.singleton(mapHttpRequest), retryDurations);
            if (mapHttpRequest.getResponse() != null) {
                return new PortMapperMappedPort(internalPort, externalPort, externalAddress, portType, leaseDuration);
            }
            retryDurations = new long[]{5000L};
            externalPort = RandomUtils.nextInt(externalPortRange.getMinimum().intValue(), externalPortRange.getMaximum().intValue() + 1);
        }
        throw new IllegalStateException();
    }

    @Override
    public void unmapPort(MappedPort mappedPort) throws InterruptedException {
        LOG.info("Attempting to unmap {}", (Object)mappedPort);
        Validate.notNull(mappedPort);
        Validate.isTrue(mappedPort instanceof PortMapperMappedPort);
        Bus networkBus = this.getNetworkBus();
        URL controlUrl = this.getControlUrl();
        String serviceType = this.getServiceType();
        int externalPort = mappedPort.getExternalPort();
        InetAddress internalAddress = this.getInternalAddress();
        PortType portType = mappedPort.getPortType();
        MapperIoUtils.TcpRequest httpRequest = new MapperIoUtils.TcpRequest(internalAddress, this.controlUrlAddress, new DeletePortMappingUpnpIgdRequest(controlUrl.getAuthority(), controlUrl.getFile(), serviceType, null, externalPort, portType), new UpnpIgdPortMapper.BasicRequestTransformer(), new MapperIoUtils.BytesToResponseTransformer(){

            @Override
            public Object create(byte[] buffer) {
                return new DeletePortMappingUpnpIgdResponse(buffer);
            }
        });
        MapperIoUtils.performTcpRequests(networkBus, Collections.singleton(httpRequest), 5000L, 5000L, 5000L);
        if (httpRequest.getResponse() == null) {
            throw new IllegalStateException("No response/invalid response to unmapping");
        }
        LOG.debug("Unmap successful {}", (Object)mappedPort);
    }

    @Override
    public MappedPort refreshPort(MappedPort mappedPort, long lifetime) throws InterruptedException {
        LOG.info("Attempting to refresh mapping {} for {}", (Object)mappedPort, (Object)lifetime);
        Validate.notNull(mappedPort);
        Validate.isTrue(mappedPort instanceof PortMapperMappedPort);
        Validate.inclusiveBetween(1L, Long.MAX_VALUE, lifetime);
        MappedPort newMappedPort = this.mapPort(mappedPort.getPortType(), mappedPort.getInternalPort(), mappedPort.getExternalPort(), lifetime);
        if (mappedPort.getExternalPort() != newMappedPort.getExternalPort() || !Objects.equals(mappedPort.getExternalAddress(), newMappedPort.getExternalAddress())) {
            LOG.warn("Failed refresh mapping {}: ", (Object)mappedPort, (Object)newMappedPort);
            try {
                this.unmapPort(newMappedPort);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            throw new IllegalStateException("External IP/port changed from " + mappedPort.getExternalAddress() + ":" + mappedPort.getExternalPort() + " to " + newMappedPort.getExternalAddress() + ":" + newMappedPort.getExternalPort());
        }
        LOG.debug("Mapping refreshed {}: ", (Object)mappedPort, (Object)newMappedPort);
        return newMappedPort;
    }

    @Override
    public String toString() {
        return "PortMapperUpnpIgdPortMapper{super=" + super.toString() + ", hasAddAnyPortMappingMethod=" + this.hasAddAnyPortMappingMethod + '}';
    }
}

