/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd;

import com.v14d4n.opentoonline.relocated.commons.lang3.Range;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.gateway.Bus;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.NetworkUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.MapperIoUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.FirewallUpnpIgdPortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.PortMapperUpnpIgdPortMapper;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.RootUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.RootUpnpIgdResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.ServiceDescriptionUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.ServiceDescriptionUpnpIgdResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.ServiceDiscoveryUpnpIgdRequest;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.ServiceDiscoveryUpnpIgdResponse;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdHttpRequest;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpnpIgdPortMapper
implements PortMapper {
    private static final Logger LOG = LoggerFactory.getLogger(UpnpIgdPortMapper.class);
    private final Bus networkBus;
    private final InetAddress internalAddress;
    private final URL controlUrl;
    private final String serverName;
    private final String serviceType;
    private final Range<Long> externalPortRange;
    private final Range<Long> leaseDurationRange;

    protected UpnpIgdPortMapper(Bus networkBus, InetAddress internalAddress, URL controlUrl, String serverName, String serviceType, Range<Long> externalPortRange, Range<Long> leaseDurationRange) {
        Validate.notNull(networkBus);
        Validate.notNull(internalAddress);
        Validate.notNull(controlUrl);
        Validate.notNull(serviceType);
        Validate.notNull(externalPortRange);
        Validate.notNull(leaseDurationRange);
        Validate.isTrue(leaseDurationRange.getMinimum() >= 0L);
        Validate.isTrue(leaseDurationRange.getMaximum() <= 0xFFFFFFFFL);
        Validate.isTrue(externalPortRange.getMinimum() >= 0L);
        Validate.isTrue(externalPortRange.getMaximum() <= 65535L);
        Validate.isTrue("http".equalsIgnoreCase(controlUrl.getProtocol()));
        this.networkBus = networkBus;
        this.internalAddress = internalAddress;
        this.controlUrl = controlUrl;
        this.serverName = serverName;
        this.serviceType = serviceType;
        this.externalPortRange = externalPortRange;
        this.leaseDurationRange = leaseDurationRange;
    }

    protected final Bus getNetworkBus() {
        return this.networkBus;
    }

    protected final InetAddress getInternalAddress() {
        return this.internalAddress;
    }

    protected final URL getControlUrl() {
        return this.controlUrl;
    }

    protected final String getServerName() {
        return this.serverName;
    }

    protected final String getServiceType() {
        return this.serviceType;
    }

    protected final Range<Long> getExternalPortRange() {
        return this.externalPortRange;
    }

    protected final Range<Long> getLeaseDurationRange() {
        return this.leaseDurationRange;
    }

    public String toString() {
        return "UpnpIgdPortMapper{internalAddress=" + this.internalAddress + ", controlUrl=" + this.controlUrl + ", serverName=" + this.serverName + ", serviceType=" + this.serviceType + ", externalPortRange=" + this.externalPortRange + ", leaseDurationRange=" + this.leaseDurationRange + '}';
    }

    public static List<UpnpIgdPortMapper> identify(Bus networkBus) throws InterruptedException {
        LOG.info("Attempting to identify devices");
        Validate.notNull(networkBus);
        Set<InetAddress> sourceAddresses = MapperIoUtils.getLocalIpAddresses(networkBus);
        LinkedList<MapperIoUtils.UdpRequest> discoveryRequests = new LinkedList<MapperIoUtils.UdpRequest>();
        for (InetAddress sourceAddress : sourceAddresses) {
            if (sourceAddress instanceof Inet4Address) {
                MapperIoUtils.UdpRequest req = new MapperIoUtils.UdpRequest(sourceAddress, ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV4.getMulticastSocketAddress(), new ServiceDiscoveryUpnpIgdRequest(ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV4, null, 3, "ssdp:all"), new BasicRequestTransformer(), new ServiceDiscoveryResponseTransformer());
                discoveryRequests.add(req);
                continue;
            }
            if (sourceAddress instanceof Inet6Address) {
                MapperIoUtils.UdpRequest v6LocalReq = new MapperIoUtils.UdpRequest(sourceAddress, ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV6_LINK_LOCAL.getMulticastSocketAddress(), new ServiceDiscoveryUpnpIgdRequest(ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV6_LINK_LOCAL, null, 3, "ssdp:all"), new BasicRequestTransformer(), new ServiceDiscoveryResponseTransformer());
                discoveryRequests.add(v6LocalReq);
                MapperIoUtils.UdpRequest udpRequest = new MapperIoUtils.UdpRequest(sourceAddress, ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV6_SITE_LOCAL.getMulticastSocketAddress(), new ServiceDiscoveryUpnpIgdRequest(ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV6_SITE_LOCAL, null, 3, "ssdp:all"), new BasicRequestTransformer(), new ServiceDiscoveryResponseTransformer());
                discoveryRequests.add(udpRequest);
                MapperIoUtils.UdpRequest v6OrgReq = new MapperIoUtils.UdpRequest(sourceAddress, ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV6_ORGANIZATION_LOCAL.getMulticastSocketAddress(), new ServiceDiscoveryUpnpIgdRequest(ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV6_ORGANIZATION_LOCAL, null, 3, "ssdp:all"), new BasicRequestTransformer(), new ServiceDiscoveryResponseTransformer());
                discoveryRequests.add(v6OrgReq);
                MapperIoUtils.UdpRequest v6GlobalReq = new MapperIoUtils.UdpRequest(sourceAddress, ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV6_GLOBAL.getMulticastSocketAddress(), new ServiceDiscoveryUpnpIgdRequest(ServiceDiscoveryUpnpIgdRequest.ProbeDeviceType.IPV6_GLOBAL, null, 3, "ssdp:all"), new BasicRequestTransformer(), new ServiceDiscoveryResponseTransformer());
                discoveryRequests.add(v6GlobalReq);
                continue;
            }
            throw new IllegalStateException();
        }
        MapperIoUtils.performUdpRequests(networkBus, discoveryRequests, true, 1000L, 1000L, 1000L, 1000L, 1000L);
        ArrayList<MapperIoUtils.TcpRequest> rootRequests = new ArrayList<MapperIoUtils.TcpRequest>(discoveryRequests.size());
        HashSet<URL> processedLocations = new HashSet<URL>();
        for (MapperIoUtils.UdpRequest udpRequest : discoveryRequests) {
            LOG.debug("Processing discovery {}", (Object)udpRequest);
            for (Object response : udpRequest.getResponses()) {
                try {
                    ServiceDiscoveryUpnpIgdResponse discoveryResp = (ServiceDiscoveryUpnpIgdResponse)response;
                    if (!processedLocations.add(discoveryResp.getLocation())) {
                        LOG.debug("Found duplicate discovery location -- skipping");
                        continue;
                    }
                    ProbeResult other = new ProbeResult();
                    other.source = udpRequest.getSourceAddress();
                    other.location = discoveryResp.getLocation();
                    other.serverName = discoveryResp.getServer();
                    MapperIoUtils.TcpRequest req = new MapperIoUtils.TcpRequest(other.source, UpnpIgdPortMapper.getAddressFromUrl(other.location), new RootUpnpIgdRequest(other.location.getAuthority(), other.location.getFile()), new BasicRequestTransformer(), new RootUpnpIgdBytesToResponseTransformer(other.location));
                    req.setOther(other);
                    rootRequests.add(req);
                }
                catch (RuntimeException iae) {
                    LOG.error("Encountered error", iae);
                }
            }
        }
        MapperIoUtils.performBatchedTcpRequests(networkBus, rootRequests, 3, 5000L, 5000L, 5000L);
        ArrayList<MapperIoUtils.TcpRequest> serviceDescRequests = new ArrayList<MapperIoUtils.TcpRequest>(rootRequests.size());
        for (MapperIoUtils.TcpRequest rootRequest : rootRequests) {
            LOG.debug("Processing root {}", (Object)rootRequest);
            try {
                RootUpnpIgdResponse rootResp = (RootUpnpIgdResponse)rootRequest.getResponse();
                for (RootUpnpIgdResponse.ServiceReference serviceReference : rootResp.getServices()) {
                    URL scpdUrl = serviceReference.getScpdUrl();
                    RootRequestResult other = new RootRequestResult();
                    other.probeResult = (ProbeResult)rootRequest.getOther();
                    other.serviceReference = serviceReference;
                    MapperIoUtils.TcpRequest req = new MapperIoUtils.TcpRequest(rootRequest.getSourceAddress(), UpnpIgdPortMapper.getAddressFromUrl(scpdUrl), new ServiceDescriptionUpnpIgdRequest(scpdUrl.getAuthority(), scpdUrl.getFile()), new BasicRequestTransformer(), new ServiceDescriptionUpnpIgdBytesToResponseTransformer());
                    req.setOther(other);
                    serviceDescRequests.add(req);
                }
            }
            catch (RuntimeException iae) {
                LOG.error("Encountered error", iae);
            }
        }
        MapperIoUtils.performBatchedTcpRequests(networkBus, serviceDescRequests, 3, 5000L, 5000L, 5000L);
        LinkedList<UpnpIgdPortMapper> linkedList = new LinkedList<UpnpIgdPortMapper>();
        for (MapperIoUtils.TcpRequest serviceDescRequest : serviceDescRequests) {
            LOG.debug("Processing description {}", (Object)serviceDescRequest);
            try {
                ServiceDescriptionUpnpIgdResponse serviceDescResp = (ServiceDescriptionUpnpIgdResponse)serviceDescRequest.getResponse();
                RootRequestResult rootReqRes = (RootRequestResult)serviceDescRequest.getOther();
                for (Map.Entry<ServiceDescriptionUpnpIgdResponse.ServiceType, ServiceDescriptionUpnpIgdResponse.IdentifiedService> e : serviceDescResp.getIdentifiedServices().entrySet()) {
                    UpnpIgdPortMapper upnpIgdPortMapper;
                    ServiceDescriptionUpnpIgdResponse.ServiceType serviceType = e.getKey();
                    ServiceDescriptionUpnpIgdResponse.IdentifiedService identifiedService = e.getValue();
                    switch (serviceType) {
                        case OLD_PORT_MAPPER: {
                            upnpIgdPortMapper = new PortMapperUpnpIgdPortMapper(networkBus, serviceDescRequest.getSourceAddress(), rootReqRes.serviceReference.getControlUrl(), rootReqRes.probeResult.serverName, rootReqRes.serviceReference.getServiceType(), identifiedService.getExternalPortRange(), identifiedService.getLeaseDurationRange(), false);
                            break;
                        }
                        case NEW_PORT_MAPPER: {
                            upnpIgdPortMapper = new PortMapperUpnpIgdPortMapper(networkBus, serviceDescRequest.getSourceAddress(), rootReqRes.serviceReference.getControlUrl(), rootReqRes.probeResult.serverName, rootReqRes.serviceReference.getServiceType(), identifiedService.getExternalPortRange(), identifiedService.getLeaseDurationRange(), true);
                            break;
                        }
                        case FIREWALL: {
                            upnpIgdPortMapper = new FirewallUpnpIgdPortMapper(networkBus, serviceDescRequest.getSourceAddress(), rootReqRes.serviceReference.getControlUrl(), rootReqRes.probeResult.serverName, rootReqRes.serviceReference.getServiceType(), identifiedService.getExternalPortRange(), identifiedService.getLeaseDurationRange());
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    linkedList.add(upnpIgdPortMapper);
                }
            }
            catch (RuntimeException iae) {
                LOG.error("Encountered error", iae);
            }
        }
        return linkedList;
    }

    @Override
    public final InetAddress getSourceAddress() {
        return this.internalAddress;
    }

    protected static final InetSocketAddress getAddressFromUrl(URL url) {
        Validate.notNull(url);
        Validate.isTrue(url.getProtocol().equalsIgnoreCase("http"));
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        Validate.isTrue(port != -1);
        return NetworkUtils.toSocketAddress(host, port);
    }

    private static final class ServiceDescriptionUpnpIgdBytesToResponseTransformer
    implements MapperIoUtils.BytesToResponseTransformer {
        private ServiceDescriptionUpnpIgdBytesToResponseTransformer() {
        }

        @Override
        public Object create(byte[] buffer) {
            return new ServiceDescriptionUpnpIgdResponse(buffer);
        }
    }

    private static final class RootUpnpIgdBytesToResponseTransformer
    implements MapperIoUtils.BytesToResponseTransformer {
        private URL baseUrl;

        private RootUpnpIgdBytesToResponseTransformer(URL baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public Object create(byte[] buffer) {
            return new RootUpnpIgdResponse(this.baseUrl, buffer);
        }
    }

    private static final class ServiceDiscoveryResponseTransformer
    implements MapperIoUtils.BytesToResponseTransformer {
        private ServiceDiscoveryResponseTransformer() {
        }

        @Override
        public Object create(byte[] buffer) {
            return new ServiceDiscoveryUpnpIgdResponse(buffer);
        }
    }

    protected static final class BasicRequestTransformer
    implements MapperIoUtils.RequestToBytesTransformer {
        protected BasicRequestTransformer() {
        }

        @Override
        public byte[] create(Object request) {
            return ((UpnpIgdHttpRequest)request).dump();
        }
    }

    private static final class RootRequestResult {
        private ProbeResult probeResult;
        private RootUpnpIgdResponse.ServiceReference serviceReference;

        private RootRequestResult() {
        }
    }

    private static final class ProbeResult {
        private InetAddress source;
        private URL location;
        private String serverName;

        private ProbeResult() {
        }
    }
}

