/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.NetworkUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdSoapRequest;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AddPinholeUpnpIgdRequest
extends UpnpIgdSoapRequest {
    public AddPinholeUpnpIgdRequest(String host, String controlLocation, String serviceType, InetAddress remoteHost, int remotePort, InetAddress internalClient, int internalPort, PortType protocol, long leaseDuration) {
        super(host, controlLocation, serviceType, "AddPinhole", AddPinholeUpnpIgdRequest.generateArguments(remoteHost, remotePort, protocol, internalPort, internalClient, leaseDuration));
    }

    private static Map<String, String> generateArguments(InetAddress remoteHost, int externalPort, PortType protocol, int internalPort, InetAddress internalClient, long leaseDuration) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (remoteHost == null) {
            ret.put("RemoteHost", "");
        } else {
            ret.put("RemoteHost", NetworkUtils.toIpv6AddressString(remoteHost));
        }
        Validate.inclusiveBetween(0L, 65535L, externalPort);
        ret.put("RemotePort", "" + externalPort);
        if (internalClient == null) {
            ret.put("InternalClient", "");
        } else {
            ret.put("InternalClient", NetworkUtils.toIpv6AddressString(internalClient));
        }
        Validate.inclusiveBetween(0L, 65535L, internalPort);
        ret.put("InternalPort", "" + internalPort);
        ret.put("Protocol", protocol == null ? "65535" : "" + protocol.getProtocolNumber());
        Validate.inclusiveBetween(1L, 0xFFFFFFFFL, leaseDuration);
        ret.put("LeaseTime", "" + leaseDuration);
        return ret;
    }

    @Override
    public String toString() {
        return "AddPinholeUpnpIgdRequest{super=" + super.toString() + '}';
    }
}

