/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdSoapRequest;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AddPortMappingUpnpIgdRequest
extends UpnpIgdSoapRequest {
    public AddPortMappingUpnpIgdRequest(String host, String controlLocation, String serviceType, InetAddress remoteHost, int externalPort, PortType protocol, int internalPort, InetAddress internalClient, boolean enabled, String description, long leaseDuration) {
        super(host, controlLocation, serviceType, "AddPortMapping", AddPortMappingUpnpIgdRequest.generateArguments(remoteHost, externalPort, protocol, internalPort, internalClient, enabled, description, leaseDuration));
    }

    private static Map<String, String> generateArguments(InetAddress remoteHost, int externalPort, PortType protocol, int internalPort, InetAddress internalClient, boolean enabled, String description, long leaseDuration) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (remoteHost == null) {
            ret.put("NewRemoteHost", "");
        } else {
            ret.put("NewRemoteHost", remoteHost.getHostAddress());
        }
        Validate.inclusiveBetween(0L, 65535L, externalPort);
        ret.put("NewExternalPort", "" + externalPort);
        Validate.notNull(protocol);
        ret.put("NewProtocol", protocol.toString());
        Validate.inclusiveBetween(1L, 65535L, internalPort);
        ret.put("NewInternalPort", "" + internalPort);
        Validate.notNull(internalClient);
        ret.put("NewInternalClient", internalClient.getHostAddress());
        ret.put("NewEnabled", enabled ? "1" : "0");
        Validate.notNull(description);
        ret.put("NewPortMappingDescription", description);
        Validate.inclusiveBetween(0L, 0xFFFFFFFFL, leaseDuration);
        ret.put("NewLeaseDuration", "" + leaseDuration);
        return ret;
    }

    @Override
    public String toString() {
        return "AddPortMappingUpnpIgdRequest{super=" + super.toString() + '}';
    }
}

