/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mapper.PortType;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdSoapRequest;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;

public final class GetSpecificPortMappingEntryUpnpIgdRequest
extends UpnpIgdSoapRequest {
    public GetSpecificPortMappingEntryUpnpIgdRequest(String host, String controlLocation, String serviceType, InetAddress remoteHost, int externalPort, PortType protocol) {
        super(host, controlLocation, serviceType, "GetSpecificPortMappingEntry", GetSpecificPortMappingEntryUpnpIgdRequest.generateArguments(remoteHost, externalPort, protocol));
    }

    private static Map<String, String> generateArguments(InetAddress remoteHost, int externalPort, PortType protocol) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (remoteHost == null) {
            ret.put("NewRemoteHost", "");
        } else {
            ret.put("NewRemoteHost", remoteHost.getHostAddress());
        }
        Validate.inclusiveBetween(0L, 65535L, externalPort);
        ret.put("NewExternalPort", "" + externalPort);
        Validate.notNull(protocol);
        ret.put("NewProtocol", protocol.toString());
        return ret;
    }

    @Override
    public String toString() {
        return "GetSpecificPortMappingEntryUpnpIgdRequest{super=" + super.toString() + '}';
    }
}

