/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdSoapResponse;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;

public final class GetSpecificPortMappingEntryUpnpIgdResponse
extends UpnpIgdSoapResponse {
    public GetSpecificPortMappingEntryUpnpIgdResponse(byte[] buffer) {
        super("GetSpecificPortMappingEntryResponse", new HashSet<String>(Arrays.asList("NewInternalPort", "NewInternalClient", "NewEnabled", "NewPortMappingDescription", "NewLeaseDuration")), buffer);
    }

    public int getInternalPort() {
        String internalPortStr = this.getArgumentIgnoreCase("NewInternalPort");
        Validate.isTrue(internalPortStr != null);
        int internalPort = Integer.parseInt(internalPortStr);
        Validate.inclusiveBetween(1L, 65535L, internalPort);
        return internalPort;
    }

    public InetAddress getInternalClient() {
        String internalClientStr = this.getArgumentIgnoreCase("NewInternalClient");
        Validate.validState(internalClientStr != null);
        try {
            return InetAddress.getByName(internalClientStr);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean getEnabled() {
        String enabledStr = this.getArgumentIgnoreCase("NewEnabled");
        Validate.validState(enabledStr != null);
        if (enabledStr.equalsIgnoreCase("1")) {
            return true;
        }
        if (enabledStr.equalsIgnoreCase("0")) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    public String getDescription() {
        String description = this.getArgumentIgnoreCase("NewPortMappingDescription");
        Validate.validState(description != null);
        return description;
    }

    public Long getLeaseDuration() {
        String leaseDurationStr = this.getArgumentIgnoreCase("NewLeaseDuration");
        Validate.validState(leaseDurationStr != null);
        long leaseDuration = Long.parseLong(leaseDurationStr);
        Validate.inclusiveBetween(0L, 0xFFFFFFFFL, leaseDuration);
        return leaseDuration;
    }

    @Override
    public String toString() {
        return "GetSpecificPortMappingEntryUpnpIgdResponse{super=" + super.toString() + '}';
    }
}

