/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.StringEscapeUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.StringUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.TextUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdHttpResponse;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RootUpnpIgdResponse
extends UpnpIgdHttpResponse {
    private List<ServiceReference> services;

    public RootUpnpIgdResponse(URL baseUrl, byte[] buffer) {
        super(buffer);
        Validate.notNull(baseUrl);
        String content = this.getContent();
        String baseUrlOverrideStr = TextUtils.findFirstBlock(content, "<URLBase>", "</URLBase>", true);
        if (baseUrlOverrideStr != null) {
            try {
                baseUrl = new URL(baseUrlOverrideStr);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        List<String> serviceBlocks = TextUtils.findAllBlocks(content, "<service>", "</service>", true);
        ArrayList<ServiceReference> servicesList = new ArrayList<ServiceReference>(serviceBlocks.size());
        for (String serviceBlock : serviceBlocks) {
            String serviceType = TextUtils.findFirstBlock(serviceBlock, "<serviceType>", "</serviceType>", true);
            String controlUrl = TextUtils.findFirstBlock(serviceBlock, "<controlURL>", "</controlURL>", true);
            String scpdUrl = TextUtils.findFirstBlock(serviceBlock, "<SCPDURL>", "</SCPDURL>", true);
            try {
                ServiceReference service = new ServiceReference(baseUrl, StringUtils.trim(StringEscapeUtils.unescapeXml(serviceType)), StringUtils.trim(StringEscapeUtils.unescapeXml(controlUrl)), StringUtils.trim(StringEscapeUtils.unescapeXml(scpdUrl)));
                servicesList.add(service);
            }
            catch (IllegalArgumentException | NullPointerException e) {}
        }
        this.services = Collections.unmodifiableList(servicesList);
    }

    public List<ServiceReference> getServices() {
        return this.services;
    }

    @Override
    public String toString() {
        return "RootUpnpIgdResponse{super=" + super.toString() + "services=" + this.services + '}';
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 67 * hash + Objects.hashCode(this.services);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RootUpnpIgdResponse other = (RootUpnpIgdResponse)obj;
        return Objects.equals(this.services, other.services);
    }

    public static final class ServiceReference {
        private final String serviceType;
        private final URL controlUrl;
        private final URL scpdUrl;

        public ServiceReference(URL baseUrl, String serviceType, String controlUrl, String scpdUrl) {
            Validate.notNull(baseUrl);
            Validate.notNull(serviceType);
            Validate.notNull(controlUrl);
            Validate.notNull(scpdUrl);
            this.serviceType = serviceType;
            try {
                this.controlUrl = baseUrl.toURI().resolve(controlUrl).toURL();
                this.scpdUrl = baseUrl.toURI().resolve(scpdUrl).toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public URL getControlUrl() {
            return this.controlUrl;
        }

        public URL getScpdUrl() {
            return this.scpdUrl;
        }

        public String toString() {
            return "ServiceReference{serviceType=" + this.serviceType + ", controlUrl=" + this.controlUrl + ", scpdUrl=" + this.scpdUrl + '}';
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + Objects.hashCode(this.serviceType);
            hash = 53 * hash + Objects.hashCode(this.controlUrl);
            hash = 53 * hash + Objects.hashCode(this.scpdUrl);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceReference other = (ServiceReference)obj;
            if (!Objects.equals(this.serviceType, other.serviceType)) {
                return false;
            }
            if (!Objects.equals(this.controlUrl, other.controlUrl)) {
                return false;
            }
            return Objects.equals(this.scpdUrl, other.scpdUrl);
        }
    }
}

