/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Range;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.TextUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdHttpResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ServiceDescriptionUpnpIgdResponse
extends UpnpIgdHttpResponse {
    private Map<ServiceType, IdentifiedService> identifiedServices;

    public ServiceDescriptionUpnpIgdResponse(byte[] buffer) {
        super(buffer);
        String content = this.getContent();
        HashMap<ServiceType, IdentifiedService> descs = new HashMap<ServiceType, IdentifiedService>();
        IdentifiedService portMappingDescription = ServiceDescriptionUpnpIgdResponse.getAsNewPortMappingService(content);
        if (portMappingDescription != null) {
            descs.put(ServiceType.NEW_PORT_MAPPER, portMappingDescription);
        } else {
            portMappingDescription = ServiceDescriptionUpnpIgdResponse.getAsOldPortMappingService(content);
            if (portMappingDescription != null) {
                descs.put(ServiceType.OLD_PORT_MAPPER, portMappingDescription);
            }
        }
        IdentifiedService firewallDescription = ServiceDescriptionUpnpIgdResponse.getAsFirewallService(content);
        if (firewallDescription != null) {
            descs.put(ServiceType.FIREWALL, firewallDescription);
        }
        this.identifiedServices = Collections.unmodifiableMap(descs);
    }

    public Map<ServiceType, IdentifiedService> getIdentifiedServices() {
        return this.identifiedServices;
    }

    private static IdentifiedService getAsOldPortMappingService(String content) {
        List<String> actionBlocks = TextUtils.findAllBlocks(content, "<action>", "</action>", true);
        List<String> stateVarBlocks = TextUtils.findAllBlocks(content, "<stateVariable>", "</stateVariable>", true);
        String getExtIpActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "GetExternalIPAddress");
        String getMappingActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "GetSpecificPortMappingEntry");
        String deleteMappingActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "DeletePortMapping");
        String addMappingActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "AddPortMapping");
        if (getExtIpActionBlock == null || getMappingActionBlock == null || deleteMappingActionBlock == null || addMappingActionBlock == null) {
            return null;
        }
        Range<Long> externalPortRange = ServiceDescriptionUpnpIgdResponse.getAllowedValueRange(addMappingActionBlock, stateVarBlocks, "NewExternalPort", Range.between(0L, 65535L));
        Range<Long> leaseTimeRange = ServiceDescriptionUpnpIgdResponse.getAllowedValueRange(addMappingActionBlock, stateVarBlocks, "NewLeaseDuration", Range.between(1L, 604800L));
        return new IdentifiedService(leaseTimeRange, externalPortRange);
    }

    private static IdentifiedService getAsNewPortMappingService(String content) {
        List<String> actionBlocks = TextUtils.findAllBlocks(content, "<action>", "</action>", true);
        List<String> stateVarBlocks = TextUtils.findAllBlocks(content, "<stateVariable>", "</stateVariable>", true);
        String getExtIpActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "GetExternalIPAddress");
        String getMappingActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "GetSpecificPortMappingEntry");
        String deleteMappingActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "DeletePortMapping");
        String addAnyMappingActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "AddAnyPortMapping");
        if (getExtIpActionBlock == null || getMappingActionBlock == null || deleteMappingActionBlock == null || addAnyMappingActionBlock == null) {
            return null;
        }
        Range<Long> externalPortRange = ServiceDescriptionUpnpIgdResponse.getAllowedValueRange(addAnyMappingActionBlock, stateVarBlocks, "NewExternalPort", Range.between(0L, 65535L));
        Range<Long> leaseTimeRange = ServiceDescriptionUpnpIgdResponse.getAllowedValueRange(addAnyMappingActionBlock, stateVarBlocks, "NewLeaseDuration", Range.between(1L, 604800L));
        return new IdentifiedService(leaseTimeRange, externalPortRange);
    }

    private static IdentifiedService getAsFirewallService(String content) {
        List<String> actionBlocks = TextUtils.findAllBlocks(content, "<action>", "</action>", true);
        List<String> stateVarBlocks = TextUtils.findAllBlocks(content, "<stateVariable>", "</stateVariable>", true);
        String addPinholeActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "AddPinhole");
        String updatePinholeActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "UpdatePinhole");
        String deletePinholeActionBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(actionBlocks, "name", "DeletePinhole");
        if (addPinholeActionBlock == null || updatePinholeActionBlock == null || deletePinholeActionBlock == null) {
            return null;
        }
        Range<Long> remotePortRange = ServiceDescriptionUpnpIgdResponse.getAllowedValueRange(addPinholeActionBlock, stateVarBlocks, "RemotePort", Range.between(0L, 65535L));
        Range<Long> addPinholeLeaseTimeRange = ServiceDescriptionUpnpIgdResponse.getAllowedValueRange(addPinholeActionBlock, stateVarBlocks, "LeaseTime", Range.between(1L, 86400L));
        Range<Long> updatePinholeLeaseTimeRange = ServiceDescriptionUpnpIgdResponse.getAllowedValueRange(updatePinholeActionBlock, stateVarBlocks, "LeaseTime", Range.between(1L, 86400L));
        Range<Long> leaseTimeRange = addPinholeLeaseTimeRange.intersectionWith(updatePinholeLeaseTimeRange);
        return new IdentifiedService(leaseTimeRange, remotePortRange);
    }

    private static Range<Long> getAllowedValueRange(String actionBlock, List<String> stateVars, String expectedArgName, Range<Long> maxRange) {
        long max;
        long min;
        List<String> argBlocks = TextUtils.findAllBlocks(actionBlock, "<argument>", "</argument>", true);
        String foundArgBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(argBlocks, "name", expectedArgName);
        if (foundArgBlock == null) {
            return maxRange;
        }
        String expectedStateVar = TextUtils.findFirstBlock(foundArgBlock, "<relatedStateVariable>", "</relatedStateVariable>", true);
        if (expectedStateVar == null) {
            return maxRange;
        }
        String foundStateVarBlock = ServiceDescriptionUpnpIgdResponse.searchBlocksForTag(stateVars, "name", expectedStateVar = expectedStateVar.trim());
        if (foundStateVarBlock == null) {
            return maxRange;
        }
        String allowedRangeBlock = TextUtils.findFirstBlock(foundStateVarBlock, "<allowedValueRange>", "</allowedValueRange>", true);
        if (allowedRangeBlock == null) {
            return maxRange;
        }
        String minStr = TextUtils.findFirstBlock(allowedRangeBlock, "<minimum>", "</minimum>", true);
        if (minStr == null) {
            min = maxRange.getMinimum();
        } else {
            try {
                min = Long.parseLong(minStr.trim());
            }
            catch (NumberFormatException nfe) {
                min = maxRange.getMinimum();
            }
        }
        String maxStr = TextUtils.findFirstBlock(allowedRangeBlock, "<maximum>", "</maximum>", true);
        if (maxStr == null) {
            max = maxRange.getMaximum();
        } else {
            try {
                max = Long.parseLong(maxStr.trim());
            }
            catch (NumberFormatException nfe) {
                max = maxRange.getMaximum();
            }
        }
        if (min > max || min < maxRange.getMinimum() || max > maxRange.getMaximum()) {
            return maxRange;
        }
        return Range.between(min, max);
    }

    private static String searchBlocksForTag(List<String> blocks, String tagToSearch, String expectedValue) {
        for (String block : blocks) {
            String name = TextUtils.findFirstBlock(block, "<" + tagToSearch + ">", "</" + tagToSearch + ">", true);
            if (name == null || !expectedValue.equalsIgnoreCase(name = name.trim())) continue;
            return block;
        }
        return null;
    }

    @Override
    public String toString() {
        return "ServiceDescriptionUpnpIgdResponse{super=" + super.toString() + "identifiedServices=" + this.identifiedServices + '}';
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 17 * hash + Objects.hashCode(this.identifiedServices);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceDescriptionUpnpIgdResponse other = (ServiceDescriptionUpnpIgdResponse)obj;
        return Objects.equals(this.identifiedServices, other.identifiedServices);
    }

    public static enum ServiceType {
        OLD_PORT_MAPPER,
        NEW_PORT_MAPPER,
        FIREWALL;

    }

    public static final class IdentifiedService {
        private Range<Long> leaseDurationRange;
        private Range<Long> externalPortRange;

        private IdentifiedService(Range<Long> leaseDurationRange, Range<Long> externalPortRange) {
            Validate.notNull(leaseDurationRange);
            Validate.notNull(externalPortRange);
            Validate.isTrue(leaseDurationRange.getMinimum() >= 0L);
            Validate.isTrue(leaseDurationRange.getMaximum() <= 0xFFFFFFFFL);
            Validate.isTrue(externalPortRange.getMinimum() >= 0L);
            Validate.isTrue(externalPortRange.getMaximum() <= 65535L);
            this.leaseDurationRange = leaseDurationRange;
            this.externalPortRange = externalPortRange;
        }

        public Range<Long> getLeaseDurationRange() {
            return this.leaseDurationRange;
        }

        public Range<Long> getExternalPortRange() {
            return this.externalPortRange;
        }

        public String toString() {
            return "IdentifiedService{super=" + super.toString() + "leaseDurationRange=" + this.leaseDurationRange + ", externalPortRange=" + this.externalPortRange + '}';
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + Objects.hashCode(this.leaseDurationRange);
            hash = 59 * hash + Objects.hashCode(this.externalPortRange);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IdentifiedService other = (IdentifiedService)obj;
            if (!Objects.equals(this.leaseDurationRange, other.leaseDurationRange)) {
                return false;
            }
            return Objects.equals(this.externalPortRange, other.externalPortRange);
        }
    }
}

