/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdHttpRequest;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ServiceDiscoveryUpnpIgdRequest
extends UpnpIgdHttpRequest {
    private static final String METHOD_NAME = "M-SEARCH";
    private static final String LOCATION = "*";
    private static final String HOST_KEY = "HOST";
    private static final String MAN_KEY = "MAN";
    private static final String MAN_VALUE = "ssdp:discover";
    private static final String MM_KEY = "MM";
    private static final String MX_KEY = "MX";
    private static final String ST_KEY = "ST";

    public ServiceDiscoveryUpnpIgdRequest(ProbeDeviceType probeDeviceType, Integer mm, Integer mx, String serviceType) {
        super(METHOD_NAME, LOCATION, ServiceDiscoveryUpnpIgdRequest.generateHeaders(probeDeviceType, mm, mx, serviceType), null);
    }

    private static Map<String, String> generateHeaders(ProbeDeviceType probeDeviceType, Integer mm, Integer mx, String serviceType) {
        Validate.notNull(probeDeviceType);
        if (mm != null) {
            Validate.isTrue(mm >= 0);
        }
        if (mx != null) {
            Validate.isTrue(mx >= 0);
        }
        if (mm != null && mx != null) {
            Validate.isTrue(mx >= mm);
        }
        Validate.notNull(serviceType);
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (mm != null) {
            ret.put(MM_KEY, mm.toString());
        }
        if (mx != null) {
            ret.put(MX_KEY, mx.toString());
        }
        ret.put(ST_KEY, serviceType);
        ret.put(MAN_KEY, MAN_VALUE);
        ret.put(HOST_KEY, probeDeviceType.getMulticastSocketAddressAsHeader());
        return ret;
    }

    @Override
    public String toString() {
        return "ServiceDiscoveryUpnpIgdRequest{super=" + super.toString() + '}';
    }

    public static enum ProbeDeviceType {
        IPV4("239.255.255.250", 1900),
        IPV6_LINK_LOCAL("[FF02::C]", 1900),
        IPV6_SITE_LOCAL("[FF05::C]", 1900),
        IPV6_ORGANIZATION_LOCAL("[FF08::C]", 1900),
        IPV6_GLOBAL("[FF0E::C]", 1900);

        private String multicastSocketAddressAsHeader;
        private InetSocketAddress multicastSocketAddress;

        private ProbeDeviceType(String multicastHost, int port) {
            InetAddress multicastAddress;
            Validate.notNull(multicastHost);
            Validate.inclusiveBetween(1L, 65535L, port);
            this.multicastSocketAddressAsHeader = multicastHost + ':' + port;
            try {
                multicastAddress = InetAddress.getByName(multicastHost);
            }
            catch (UnknownHostException uhe) {
                throw new IllegalArgumentException(uhe);
            }
            this.multicastSocketAddress = new InetSocketAddress(multicastAddress, port);
        }

        private String getMulticastSocketAddressAsHeader() {
            return this.multicastSocketAddressAsHeader;
        }

        public InetSocketAddress getMulticastSocketAddress() {
            return this.multicastSocketAddress;
        }
    }
}

