/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class UpnpIgdHttpRequest {
    private static final String HTTP_VERSION = "HTTP/1.1";
    private static final String TERMINATOR = "\r\n";
    private final String method;
    private final String location;
    private final Map<String, String> headers;
    private final String content;

    UpnpIgdHttpRequest(String method, String location, Map<String, String> headers, String content) {
        Validate.notNull(method);
        Validate.notNull(location);
        Validate.notNull(headers);
        Validate.noNullElements(headers.keySet());
        Validate.noNullElements(headers.values());
        for (String header : headers.keySet()) {
            if (!header.equalsIgnoreCase("Content-Length")) continue;
            throw new IllegalArgumentException();
        }
        this.method = method;
        this.location = location;
        this.headers = new LinkedHashMap<String, String>(headers);
        this.content = content;
    }

    public final byte[] dump() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method).append(' ').append(this.location).append(' ').append(HTTP_VERSION).append(TERMINATOR);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append(TERMINATOR);
        }
        if (this.content != null) {
            byte[] contentBytes = this.content.getBytes(Charset.forName("US-ASCII"));
            sb.append("Content-Length: ").append(contentBytes.length).append(TERMINATOR);
            sb.append(TERMINATOR);
            byte[] headerBytes = sb.toString().getBytes(Charset.forName("US-ASCII"));
            byte[] finalBytes = new byte[contentBytes.length + headerBytes.length];
            System.arraycopy(headerBytes, 0, finalBytes, 0, headerBytes.length);
            System.arraycopy(contentBytes, 0, finalBytes, headerBytes.length, contentBytes.length);
            return finalBytes;
        }
        sb.append(TERMINATOR);
        return sb.toString().getBytes(Charset.forName("US-ASCII"));
    }

    public String toString() {
        return "UpnpIgdHttpRequest{method=" + this.method + ", location=" + this.location + ", headers=" + this.headers + ", content=" + this.content + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Objects.hashCode(this.method);
        hash = 11 * hash + Objects.hashCode(this.location);
        hash = 11 * hash + Objects.hashCode(this.headers);
        hash = 11 * hash + Objects.hashCode(this.content);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpnpIgdHttpRequest other = (UpnpIgdHttpRequest)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        if (!Objects.equals(this.content, other.content)) {
            return false;
        }
        return Objects.equals(this.headers, other.headers);
    }
}

