/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.StringUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

public abstract class UpnpIgdHttpResponse {
    private static final String TERMINATOR = "\r\n";
    private static final String HEADER_SPLIT_POINT = "\r\n\r\n";
    private final Map<String, String> headers;
    private final String content;

    UpnpIgdHttpResponse(Map<String, String> headers, String content) {
        Validate.notNull(headers);
        Validate.noNullElements(headers.keySet());
        Validate.noNullElements(headers.values());
        for (String header : headers.keySet()) {
            if (!header.equalsIgnoreCase("Content-Length")) continue;
            throw new IllegalArgumentException();
        }
        this.headers = new HashMap<String, String>(headers);
        this.content = content;
    }

    UpnpIgdHttpResponse(byte[] buffer) {
        String headerLine;
        String contentStr;
        String headersStr;
        Validate.notNull(buffer);
        String bufferStr = new String(buffer, Charset.forName("US-ASCII"));
        int splitIdx = bufferStr.indexOf(HEADER_SPLIT_POINT);
        if (splitIdx == -1) {
            headersStr = bufferStr;
            contentStr = null;
        } else {
            headersStr = bufferStr.substring(0, splitIdx);
            contentStr = bufferStr.substring(splitIdx + HEADER_SPLIT_POINT.length());
        }
        StringTokenizer tokenizer = new StringTokenizer(headersStr, TERMINATOR);
        HashMap<String, String> headers = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens() && !(headerLine = tokenizer.nextToken().trim()).isEmpty()) {
            String[] splitLine = StringUtils.split(headerLine, ":", 2);
            if (splitLine.length != 2) continue;
            String key = splitLine[0].trim();
            String value = splitLine[1].trim();
            headers.put(key, value);
        }
        this.headers = Collections.unmodifiableMap(headers);
        this.content = contentStr;
    }

    final String getHeaderIgnoreCase(String key) {
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            if (!header.getKey().equalsIgnoreCase(key)) continue;
            return header.getValue();
        }
        return null;
    }

    final String getContent() {
        return this.content;
    }

    public String toString() {
        return "UpnpIgdHttpResponse{headers=" + this.headers + ", content=" + this.content + '}';
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.headers);
        hash = 29 * hash + Objects.hashCode(this.content);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpnpIgdHttpResponse other = (UpnpIgdHttpResponse)obj;
        if (!Objects.equals(this.content, other.content)) {
            return false;
        }
        return Objects.equals(this.headers, other.headers);
    }
}

