/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.StringEscapeUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdHttpRequest;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class UpnpIgdSoapRequest
extends UpnpIgdHttpRequest {
    UpnpIgdSoapRequest(String host, String location, String serviceType, String actionName, Map<String, String> arguments) {
        super("POST", location, UpnpIgdSoapRequest.generateHeaders(host, serviceType, actionName), UpnpIgdSoapRequest.generateContent(serviceType, actionName, arguments));
    }

    private static Map<String, String> generateHeaders(String host, String serviceType, String actionName) {
        Validate.notNull(serviceType);
        Validate.notNull(actionName);
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        ret.put("Host", host);
        ret.put("Content-Type", "text/xml");
        ret.put("SOAPAction", serviceType + "#" + actionName);
        ret.put("Connection", "Close");
        ret.put("Cache-Control", "no-cache");
        ret.put("Pragma", "no-cache");
        return ret;
    }

    private static String generateContent(String serviceType, String actionName, Map<String, String> arguments) {
        Validate.notNull(serviceType);
        Validate.notNull(actionName);
        Validate.notNull(arguments);
        Validate.noNullElements(arguments.keySet());
        Validate.noNullElements(arguments.values());
        serviceType = StringEscapeUtils.escapeXml10(serviceType);
        actionName = StringEscapeUtils.escapeXml10(actionName);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<soap:Envelope ").append("xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" ").append("soap:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        sb.append("<soap:Body>");
        sb.append("<u:").append(actionName).append(" xmlns:u=\"").append(serviceType).append("\">");
        for (Map.Entry<String, String> argument : arguments.entrySet()) {
            String key = StringEscapeUtils.escapeXml10(argument.getKey());
            String val = StringEscapeUtils.escapeXml10(argument.getValue());
            sb.append("<").append(key).append(">").append(val).append("</").append(key).append(">");
        }
        sb.append("</u:").append(actionName).append(">");
        sb.append("</soap:Body>");
        sb.append("</soap:Envelope>");
        return sb.toString();
    }

    @Override
    public String toString() {
        return "UpnpIgdSoapRequest{super=" + super.toString() + '}';
    }
}

