/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages;

import com.v14d4n.opentoonline.relocated.commons.lang3.StringEscapeUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.StringUtils;
import com.v14d4n.opentoonline.relocated.commons.lang3.Validate;
import com.v14d4n.opentoonline.relocated.portmapper.helpers.TextUtils;
import com.v14d4n.opentoonline.relocated.portmapper.mappers.upnpigd.externalmessages.UpnpIgdHttpResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class UpnpIgdSoapResponse
extends UpnpIgdHttpResponse {
    private Map<String, String> arguments;

    UpnpIgdSoapResponse(String expectedResponseAction, Set<String> expectedArguments, byte[] buffer) {
        super(buffer);
        Validate.notNull(expectedArguments);
        Validate.noNullElements(expectedArguments);
        String content = this.getContent();
        String responseBlock = TextUtils.findFirstBlock(content, ":" + expectedResponseAction, ":" + expectedResponseAction, true);
        Validate.isTrue(responseBlock != null);
        HashMap<String, String> args = new HashMap<String, String>();
        for (String key : expectedArguments) {
            String value = TextUtils.findFirstBlock(responseBlock, key + ">", key + ">", true);
            if ((value = StringUtils.substringBeforeLast(value, "<")) == null) continue;
            value = StringEscapeUtils.unescapeXml(value).trim();
            args.put(key, value);
        }
        this.arguments = Collections.unmodifiableMap(args);
    }

    final String getArgumentIgnoreCase(String key) {
        for (Map.Entry<String, String> header : this.arguments.entrySet()) {
            if (!header.getKey().equalsIgnoreCase(key)) continue;
            return header.getValue().trim();
        }
        return null;
    }

    @Override
    public String toString() {
        return "UpnpIgdSoapResponse{super=" + super.toString() + "arguments=" + this.arguments + '}';
    }
}

