/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.relocated.weupnp;

import com.v14d4n.opentoonline.relocated.weupnp.GatewayDevice;
import com.v14d4n.opentoonline.relocated.weupnp.GatewayDiscover;
import com.v14d4n.opentoonline.relocated.weupnp.PortMappingEntry;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;

public class Main {
    private static int SAMPLE_PORT = 6991;
    private static short WAIT_TIME = (short)10;
    private static boolean LIST_ALL_MAPPINGS = false;

    public static void main(String[] args) throws Exception {
        Main.addLogLine("Starting weupnp");
        GatewayDiscover gatewayDiscover = new GatewayDiscover();
        Main.addLogLine("Looking for Gateway Devices...");
        Map<InetAddress, GatewayDevice> gateways = gatewayDiscover.discover();
        if (gateways.isEmpty()) {
            Main.addLogLine("No gateways found");
            Main.addLogLine("Stopping weupnp");
            return;
        }
        Main.addLogLine(gateways.size() + " gateway(s) found\n");
        int counter = 0;
        for (GatewayDevice gw : gateways.values()) {
            Main.addLogLine("Listing gateway details of device #" + ++counter + "\n\tFriendly name: " + gw.getFriendlyName() + "\n\tPresentation URL: " + gw.getPresentationURL() + "\n\tModel name: " + gw.getModelName() + "\n\tModel number: " + gw.getModelNumber() + "\n\tLocal interface address: " + gw.getLocalAddress().getHostAddress() + "\n");
        }
        GatewayDevice activeGW = gatewayDiscover.getValidGateway();
        if (null == activeGW) {
            Main.addLogLine("No active gateway device found");
            Main.addLogLine("Stopping weupnp");
            return;
        }
        Main.addLogLine("Using gateway: " + activeGW.getFriendlyName());
        Integer portMapCount = activeGW.getPortMappingNumberOfEntries();
        Main.addLogLine("GetPortMappingNumberOfEntries: " + (portMapCount != null ? portMapCount.toString() : "(unsupported)"));
        PortMappingEntry portMapping = new PortMappingEntry();
        if (LIST_ALL_MAPPINGS) {
            int pmCount = 0;
            do {
                if (!activeGW.getGenericPortMappingEntry(pmCount, portMapping)) {
                    Main.addLogLine("Portmapping #" + pmCount + " retrieval failed");
                    break;
                }
                Main.addLogLine("Portmapping #" + pmCount + " successfully retrieved (" + portMapping.getPortMappingDescription() + ":" + portMapping.getExternalPort() + ")");
                ++pmCount;
            } while (portMapping != null);
        } else if (activeGW.getGenericPortMappingEntry(0, portMapping)) {
            Main.addLogLine("Portmapping #0 successfully retrieved (" + portMapping.getPortMappingDescription() + ":" + portMapping.getExternalPort() + ")");
        } else {
            Main.addLogLine("Portmapping #0 retrival failed");
        }
        InetAddress localAddress = activeGW.getLocalAddress();
        Main.addLogLine("Using local address: " + localAddress.getHostAddress());
        String externalIPAddress = activeGW.getExternalIPAddress();
        Main.addLogLine("External address: " + externalIPAddress);
        Main.addLogLine("Querying device to see if a port mapping already exists for port " + SAMPLE_PORT);
        if (activeGW.getSpecificPortMappingEntry(SAMPLE_PORT, "TCP", portMapping)) {
            Main.addLogLine("Port " + SAMPLE_PORT + " is already mapped. Aborting test.");
            return;
        }
        Main.addLogLine("Mapping free. Sending port mapping request for port " + SAMPLE_PORT);
        if (activeGW.addPortMapping(SAMPLE_PORT, SAMPLE_PORT, localAddress.getHostAddress(), "TCP", "test")) {
            Main.addLogLine("Mapping SUCCESSFUL. Waiting " + WAIT_TIME + " seconds before removing mapping...");
            Thread.sleep(1000 * WAIT_TIME);
            if (activeGW.deletePortMapping(SAMPLE_PORT, "TCP")) {
                Main.addLogLine("Port mapping removed, test SUCCESSFUL");
            } else {
                Main.addLogLine("Port mapping removal FAILED");
            }
        }
        Main.addLogLine("Stopping weupnp");
    }

    private static void addLogLine(String line) {
        String timeStamp = DateFormat.getTimeInstance().format(new Date());
        String logline = timeStamp + ": " + line + "\n";
        System.out.print(logline);
    }
}

