/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.v14d4n.opentoonline.commands.OpenToOnlineCommand;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.screens.AdvancedSettingsScreen;
import com.v14d4n.opentoonline.screens.RecreateFirewallRulesScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShareToOnlineScreen
extends Screen {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private static final TextComponent ALLOW_COMMANDS_LABEL = new TranslationTextComponent("selectWorld.allowCommands");
    private static final TextComponent GAME_MODE_LABEL = new TranslationTextComponent("selectWorld.gameMode");
    private static final TextComponent SETTINGS_INFO_TEXT = new TranslationTextComponent("lanServer.otherPlayers");
    private static final TextComponent PORT_INFO_TEXT = new TranslationTextComponent("gui.opentoonline.portInfo");
    private static final TextComponent MAX_PLAYERS_INFO_TEXT = new TranslationTextComponent("gui.opentoonline.maxPlayersInfo");
    private final Screen lastScreen;
    private GameType gameMode;
    private boolean commands;
    private Button openToOnlineButton;
    private Button commandsButton;
    private Button modeButton;
    private TextFieldWidget portEditBox;
    private TextFieldWidget maxPlayersEditBox;
    private String initPort = ((Integer)OpenToOnlineConfig.port.get()).toString();
    private String initMaxPlayers = ((Integer)OpenToOnlineConfig.maxPlayers.get()).toString();

    public ShareToOnlineScreen(Screen pLastScreen) {
        super((ITextComponent)new TranslationTextComponent("gui.opentoonline.onlineWorld"));
        this.lastScreen = pLastScreen;
        this.gameMode = ShareToOnlineScreen.minecraft.field_71442_b.func_178889_l();
        this.commands = ShareToOnlineScreen.minecraft.field_71439_g.func_211513_k(4);
    }

    protected void func_231160_c_() {
        this.createGameModeButton();
        this.createAllowCommandsButton();
        this.createPortEditBox();
        this.createMaxPlayersEditBox();
        this.createOpenToOnlineButton();
        this.createOpenToLanButton();
        this.createAdvancedSettingsButton();
        this.createRecreateFirewallRulesButton();
        this.createCancelButton();
        this.updateSelectionStrings();
    }

    public void func_231023_e_() {
        this.portEditBox.func_146178_a();
        this.maxPlayersEditBox.func_146178_a();
        if (this.portEditBox.func_230999_j_()) {
            this.maxPlayersEditBox.func_146195_b(false);
        }
    }

    private void createRecreateFirewallRulesButton() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ / 4 + 69, 150, 20, (ITextComponent)new TranslationTextComponent("gui.opentoonline.recreateFirewallRules"), p_96657_ -> minecraft.func_147108_a((Screen)new RecreateFirewallRulesScreen(this)), (pButton, pPoseStack, pMouseX, pMouseY) -> this.func_238654_b_(pPoseStack, ShareToOnlineScreen.minecraft.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("tooltip.opentoonline.recreateFirewallRules"), 200), pMouseX, pMouseY)));
    }

    private void createAdvancedSettingsButton() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 4 + 69, 150, 20, (ITextComponent)new TranslationTextComponent("gui.opentoonline.advancedSettings"), p_213094_1_ -> minecraft.func_147108_a((Screen)new AdvancedSettingsScreen(this))));
    }

    private void createCancelButton() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240633_d_, p_213094_1_ -> minecraft.func_147108_a(this.lastScreen)));
    }

    private void createOpenToOnlineButton() {
        this.openToOnlineButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 28, 150, 20, (ITextComponent)new TranslationTextComponent("gui.opentoonline.startOnlineWorld"), p_213094_1_ -> {
            minecraft.func_147108_a(null);
            int port = Integer.parseInt(this.portEditBox.func_146179_b());
            int maxPlayers = Integer.parseInt(this.maxPlayersEditBox.func_146179_b());
            new Thread(() -> OpenToOnlineCommand.open(port, maxPlayers, this.gameMode, this.commands)).start();
        }));
    }

    private void createOpenToLanButton() {
        this.openToOnlineButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 51, 150, 20, (ITextComponent)new TranslationTextComponent("gui.opentoonline.startLanWorld"), p_213094_1_ -> {
            minecraft.func_147108_a(null);
            int port = Integer.parseInt(this.portEditBox.func_146179_b());
            int maxPlayers = Integer.parseInt(this.maxPlayersEditBox.func_146179_b());
            new Thread(() -> OpenToOnlineCommand.open(port, maxPlayers, this.gameMode, this.commands, false)).start();
        }));
    }

    private void createPortEditBox() {
        this.portEditBox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 155 + 1, this.field_230709_l_ / 4 + 45, 148, 20, (ITextComponent)new StringTextComponent(""));
        this.portEditBox.func_146180_a(this.initPort);
        this.portEditBox.func_212954_a(pResponder -> {
            this.initPort = pResponder;
            this.openToOnlineButton.field_230693_o_ = this.isEditBoxesValuesValid();
        });
        this.func_230481_d_((IGuiEventListener)this.portEditBox);
    }

    private void createMaxPlayersEditBox() {
        this.maxPlayersEditBox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 5 + 1, this.field_230709_l_ / 4 + 45, 148, 20, (ITextComponent)new StringTextComponent(""));
        this.maxPlayersEditBox.func_146180_a(this.initMaxPlayers);
        this.maxPlayersEditBox.func_212954_a(pResponder -> {
            this.initMaxPlayers = pResponder;
            this.openToOnlineButton.field_230693_o_ = this.isEditBoxesValuesValid();
        });
        this.func_230481_d_((IGuiEventListener)this.maxPlayersEditBox);
    }

    private void createAllowCommandsButton() {
        this.commandsButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 4 + 8, 150, 20, (ITextComponent)ALLOW_COMMANDS_LABEL, p_213083_1_ -> {
            this.commands = !this.commands;
            this.updateSelectionStrings();
        }));
    }

    private void createGameModeButton() {
        this.modeButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ / 4 + 8, 150, 20, (ITextComponent)GAME_MODE_LABEL, p_213084_1_ -> {
            this.gameMode = GameType.SPECTATOR.equals((Object)this.gameMode) ? GameType.CREATIVE : (GameType.CREATIVE.equals((Object)this.gameMode) ? GameType.ADVENTURE : (GameType.ADVENTURE.equals((Object)this.gameMode) ? GameType.SURVIVAL : GameType.SPECTATOR));
            this.updateSelectionStrings();
        }));
    }

    private void updateSelectionStrings() {
        this.modeButton.func_238482_a_((ITextComponent)new TranslationTextComponent("options.generic_value", new Object[]{GAME_MODE_LABEL, new TranslationTextComponent("selectWorld.gameMode." + this.gameMode.func_77149_b())}));
        this.commandsButton.func_238482_a_((ITextComponent)DialogTexts.func_244281_a((ITextComponent)ALLOW_COMMANDS_LABEL, (boolean)this.commands));
    }

    public void func_230430_a_(MatrixStack pPoseStack, int pMouseX, int pMouseY, float pPartialTicks) {
        this.func_230446_a_(pPoseStack);
        this.portEditBox.func_230430_a_(pPoseStack, pMouseX, pMouseY, pPartialTicks);
        this.maxPlayersEditBox.func_230430_a_(pPoseStack, pMouseX, pMouseY, pPartialTicks);
        ShareToOnlineScreen.func_238472_a_((MatrixStack)pPoseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)(Math.max(52, this.field_230709_l_ / 4 - 8) - 22), (int)0xFFFFFF);
        ShareToOnlineScreen.func_238472_a_((MatrixStack)pPoseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)SETTINGS_INFO_TEXT, (int)(this.field_230708_k_ / 2), (int)Math.max(52, this.field_230709_l_ / 4 - 8), (int)0xFFFFFF);
        ShareToOnlineScreen.func_238475_b_((MatrixStack)pPoseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)PORT_INFO_TEXT, (int)this.portEditBox.field_230690_l_, (int)(this.portEditBox.field_230691_m_ - this.portEditBox.func_238483_d_() / 2 - 1), (int)0xFFFFFF);
        ShareToOnlineScreen.func_238475_b_((MatrixStack)pPoseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)MAX_PLAYERS_INFO_TEXT, (int)this.maxPlayersEditBox.field_230690_l_, (int)(this.maxPlayersEditBox.field_230691_m_ - this.maxPlayersEditBox.func_238483_d_() / 2 - 1), (int)0xFFFFFF);
        super.func_230430_a_(pPoseStack, pMouseX, pMouseY, pPartialTicks);
    }

    private boolean isEditBoxesValuesValid() {
        try {
            int port = Integer.parseInt(this.portEditBox.func_146179_b());
            int maxPlayers = Integer.parseInt(this.maxPlayersEditBox.func_146179_b());
            return port >= 0 && port <= 65535 && maxPlayers > 0;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

