/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.events;

import com.mojang.brigadier.CommandDispatcher;
import com.v14d4n.opentoonline.commands.OpenToOnlineCommand;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.ServerHandler;
import com.v14d4n.opentoonline.network.UPnPHandler;
import com.v14d4n.opentoonline.network.chat.ModChatTranslatableComponent;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="opentoonline")
public class ModEvents {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final String clientPlayerName = minecraft.m_91094_().m_92546_();

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        new OpenToOnlineCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        UPnPHandler.onPlayerLoggedOut(event);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        String loggedInPlayerName = event.getPlayer().m_7755_().getString();
        if (clientPlayerName.equals(loggedInPlayerName)) {
            ModEvents.checkUpdates(event.getPlayer());
        }
        if (ServerHandler.isPlayerServerOwner(minecraft.m_91094_().m_92548_()) && ((Boolean)OpenToOnlineConfig.whitelistMode.get()).booleanValue()) {
            ServerPlayer serverPlayer = (ServerPlayer)event.getPlayer();
            ((ArrayList)OpenToOnlineConfig.friends.get()).forEach(friendList -> {
                if (friendList.equals(serverPlayer.m_7755_().getString())) {
                    return;
                }
                serverPlayer.f_8906_.m_9942_((Component)new TextComponent("asd"));
            });
        }
    }

    private static void checkUpdates(Player player) {
        IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById("opentoonline").get()).getModInfo();
        VersionChecker.CheckResult updateCheckResult = VersionChecker.getResult((IModInfo)modInfo);
        if (updateCheckResult.status().equals((Object)VersionChecker.Status.BETA_OUTDATED)) {
            String currentVersion = modInfo.getVersion().toString().substring(modInfo.getVersion().toString().lastIndexOf(45) + 1);
            String actualVersion = updateCheckResult.target().toString().substring(updateCheckResult.target().toString().lastIndexOf(45) + 1);
            String mainText = new ModChatTranslatableComponent("chat.opentoonline.update", ModChatTranslatableComponent.MessageTypes.WARN).getString() + " \u00a7c" + currentVersion + "\u00a7r -> \u00a7a" + actualVersion + "\u00a7r";
            MutableComponent link = new TranslatableComponent("chat.opentoonline.link").m_6270_(Style.f_131099_.setUnderlined(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, updateCheckResult.url())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("tooltip.opentoonline.openUrl"))));
            MutableComponent message = new TextComponent(mainText).m_130946_(" [").m_7220_((Component)link).m_130946_("]");
            player.m_6352_((Component)message, UUID.randomUUID());
        }
    }
}

