/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.network.upnp;

import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.upnp.IUPnPLibrary;
import com.v14d4n.opentoonline.network.upnp.WaifUPnPLibrary;
import com.v14d4n.opentoonline.network.upnp.WeupnpLibrary;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum UPnPLibraries {
    Weupnp(0, WeupnpLibrary::new),
    WaifUPnP(1, WaifUPnPLibrary::new);

    private final int id;
    private final Supplier<IUPnPLibrary> librarySupplier;

    private UPnPLibraries(int id, Supplier<IUPnPLibrary> librarySupplier) {
        this.id = id;
        this.librarySupplier = librarySupplier;
    }

    public int getId() {
        return this.id;
    }

    public IUPnPLibrary getHandler() {
        return this.librarySupplier.get();
    }

    public Component getTextComponent() {
        return new TextComponent(this.name());
    }

    public static UPnPLibraries getById(int id) {
        for (UPnPLibraries library : UPnPLibraries.values()) {
            if (library.getId() != id) continue;
            return library;
        }
        OpenToOnlineConfig.libraryId.set((Object)0);
        return UPnPLibraries.getById(0);
    }
}

