/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.v14d4n.opentoonline.OpenToOnline;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.ServerHandler;
import com.v14d4n.opentoonline.network.UPnPHandler;
import com.v14d4n.opentoonline.network.chat.ModChatTranslatableComponent;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.GameType;

public class OpenToOnlineCommand {
    public OpenToOnlineCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"open2online").executes(command -> OpenToOnlineCommand.open()));
    }

    public static int open() {
        int port = (Integer)OpenToOnlineConfig.port.get();
        int maxPlayers = (Integer)OpenToOnlineConfig.maxPlayers.get();
        GameType gameMode = OpenToOnline.minecraft.f_91072_.m_105295_();
        boolean allowCheats = OpenToOnline.minecraft.f_91074_.m_8088_() == 4;
        return OpenToOnlineCommand.open(port, maxPlayers, gameMode, allowCheats);
    }

    public static int open(int port, int maxPlayers, GameType gameMode, boolean allowCommands) {
        if (ServerHandler.isServerPublished()) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.error.serverIsAlreadyPublished", ModChatTranslatableComponent.MessageTypes.ERROR));
            return 0;
        }
        if (!UPnPHandler.isPortAvailable(port)) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.error.publishFailed", ModChatTranslatableComponent.MessageTypes.ERROR));
            return 0;
        }
        OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.startingServer"));
        if (!ServerHandler.startServer(port, maxPlayers, gameMode, allowCommands)) {
            return 0;
        }
        return 1;
    }
}

