/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.network;

import com.mojang.authlib.GameProfile;
import com.v14d4n.opentoonline.OpenToOnline;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.UPnPHandler;
import com.v14d4n.opentoonline.network.chat.ModChatTranslatableComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ServerHandler {
    public static boolean startServer(int port, int maxPlayers, GameType gameMode, boolean allowCommands) {
        if (!UPnPHandler.openPort(port)) {
            return false;
        }
        if (!OpenToOnline.minecraft.m_91092_().m_7386_(gameMode, allowCommands, port)) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.error.publishFailed", ModChatTranslatableComponent.MessageTypes.ERROR));
            UPnPHandler.closePort(port);
            return false;
        }
        ServerHandler.setMaxPlayers(maxPlayers);
        ServerHandler.setupServerConfiguration();
        OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.gameHostedOn").m_7220_((Component)ServerHandler.getServerFormattedAddress(port)));
        return true;
    }

    private static void setupServerConfiguration() {
        UPnPHandler.closePortAfterLogout(true);
        ServerHandler.setPvpAllowed((Boolean)OpenToOnlineConfig.allowPvp.get());
    }

    public static boolean isServerPublished() {
        return !OpenToOnline.minecraft.m_91091_() || OpenToOnline.minecraft.m_91092_().m_6992_();
    }

    private static void setLicenseGameRequired(boolean requireLicense) {
        OpenToOnline.minecraft.m_91092_().m_129985_(requireLicense);
    }

    private static void setPvpAllowed(boolean allowPvp) {
        OpenToOnline.minecraft.m_91092_().m_129997_(allowPvp);
    }

    private static boolean setMaxPlayers(int maxPlayers) {
        PlayerList playerList = OpenToOnline.minecraft.m_91092_().m_6846_();
        try {
            Field field = PlayerList.class.getDeclaredField("f_11193_");
            field.setAccessible(true);
            field.setInt(playerList, maxPlayers);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.warn.settingMaxPlayers", ModChatTranslatableComponent.MessageTypes.WARN));
            return false;
        }
        OpenToOnlineConfig.maxPlayers.set((Object)maxPlayers);
        return true;
    }

    private static String getExternalIP() {
        try {
            String currentIP = new BufferedReader(new InputStreamReader(new URL("https://checkip.amazonaws.com").openStream())).readLine();
            String lastIP = (String)OpenToOnlineConfig.lastIP.get();
            if (!currentIP.equals(lastIP) && !lastIP.equals("0.0.0.0")) {
                OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.ipIsChanged", ModChatTranslatableComponent.MessageTypes.WARN));
            }
            OpenToOnlineConfig.lastIP.set((Object)currentIP);
            return currentIP;
        }
        catch (IOException e) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.warn.gettingAnExternalIP", ModChatTranslatableComponent.MessageTypes.WARN));
            return "0.0.0.0";
        }
    }

    private static MutableComponent getServerFormattedAddress(int port) {
        String stringAddress = ServerHandler.getExternalIP() + ":" + port;
        MutableComponent serverAddress = new TextComponent(stringAddress).m_6270_(Style.f_131099_.setUnderlined(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, stringAddress)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("tooltip.opentoonline.copy"))));
        return new TextComponent(" [").m_7220_((Component)serverAddress).m_130946_("]");
    }

    public static boolean isPlayerServerOwner(GameProfile gameProfile) {
        return OpenToOnline.minecraft.m_91092_().m_7779_(gameProfile);
    }

    public static boolean isClientRunningOnlineServer() {
        return UPnPHandler.getClosePortAfterLogout();
    }
}

