/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.network;

import com.v14d4n.opentoonline.OpenToOnline;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.network.chat.ModChatTranslatableComponent;
import com.v14d4n.opentoonline.network.upnp.IUPnPLibrary;
import com.v14d4n.opentoonline.network.upnp.UPnPLibraries;
import java.io.IOException;
import java.net.Socket;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class UPnPHandler {
    private static boolean closePortAfterLogout;
    private static IUPnPLibrary UPnP;

    private static boolean isUPnPAvailable() {
        UPnP = UPnPLibraries.getById((Integer)OpenToOnlineConfig.libraryId.get()).getHandler();
        if (UPnP.isUPnPAvailable()) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.upnpIsAvailable"));
            return true;
        }
        OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.error.upnpIsNotAvailable", ModChatTranslatableComponent.MessageTypes.ERROR));
        return false;
    }

    public static boolean openPort(int port) {
        if (!UPnPHandler.isUPnPAvailable()) {
            return false;
        }
        OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.openingTcpPort").m_130946_(" " + port + "..."));
        if (UPnP.isMappedTCP(port)) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.portIsAlreadyOpen"));
        } else if (UPnP.openPortTCP(port)) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.portIsOpen"));
        } else {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.error.portOpening", ModChatTranslatableComponent.MessageTypes.ERROR));
            return false;
        }
        OpenToOnlineConfig.port.set((Object)port);
        return true;
    }

    public static boolean closePort(int port) {
        if (UPnP == null) {
            throw new RuntimeException("UPnP library is not installed");
        }
        OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.closingTcpPort").m_130946_(" " + port + "..."));
        if (!UPnP.isMappedTCP(port)) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.portIsAlreadyClosed"));
        } else if (UPnP.closePortTCP(port)) {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.portIsClosed"));
        } else {
            OpenToOnline.minecraft.f_91065_.m_93076_().m_93785_((Component)new ModChatTranslatableComponent("chat.opentoonline.error.portClosing", ModChatTranslatableComponent.MessageTypes.ERROR));
            return false;
        }
        return true;
    }

    public static void closePortAfterLogout(boolean closePortAfterLogout) {
        UPnPHandler.closePortAfterLogout = closePortAfterLogout;
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        String loggedOutPlayerName;
        String clientPlayerName = OpenToOnline.minecraft.m_91094_().m_92546_();
        if (clientPlayerName.equals(loggedOutPlayerName = event.getPlayer().m_7755_().getString()) && closePortAfterLogout) {
            UPnPHandler.closePortAfterLogout(false);
            int port = (Integer)OpenToOnlineConfig.port.get();
            if (UPnP.isMappedTCP(port)) {
                UPnP.closePortTCP(port);
            }
        }
    }

    public static boolean isPortAvailable(int port) {
        boolean bl;
        Socket ignored = new Socket("localhost", port);
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored2) {
                return true;
            }
        }
        ignored.close();
        return bl;
    }

    public static boolean getClosePortAfterLogout() {
        return closePortAfterLogout;
    }
}

