/*
 * Decompiled with CFR 0.152.
 */
package com.v14d4n.opentoonline.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.v14d4n.opentoonline.commands.OpenToOnlineCommand;
import com.v14d4n.opentoonline.config.OpenToOnlineConfig;
import com.v14d4n.opentoonline.screens.AdvancedSettingsScreen;
import com.v14d4n.opentoonline.screens.RecreateFirewallRulesScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShareToOnlineScreen
extends Screen {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final Component ALLOW_COMMANDS_LABEL = Component.m_237115_((String)"selectWorld.allowCommands");
    private static final Component GAME_MODE_LABEL = Component.m_237115_((String)"selectWorld.gameMode");
    private static final Component SETTINGS_INFO_TEXT = Component.m_237115_((String)"lanServer.otherPlayers");
    private static final Component PORT_INFO_TEXT = Component.m_237115_((String)"gui.opentoonline.portInfo");
    private static final Component MAX_PLAYERS_INFO_TEXT = Component.m_237115_((String)"gui.opentoonline.maxPlayersInfo");
    private final Screen lastScreen;
    private GameType gameMode;
    private boolean commands;
    private Button openToOnlineButton;
    private EditBox portEditBox;
    private EditBox maxPlayersEditBox;
    private String initPort = ((Integer)OpenToOnlineConfig.port.get()).toString();
    private String initMaxPlayers = ((Integer)OpenToOnlineConfig.maxPlayers.get()).toString();

    public ShareToOnlineScreen(Screen pLastScreen) {
        super((Component)Component.m_237115_((String)"gui.opentoonline.onlineWorld"));
        this.lastScreen = pLastScreen;
        this.gameMode = ShareToOnlineScreen.minecraft.f_91072_.m_105295_();
        this.commands = ShareToOnlineScreen.minecraft.f_91074_.m_8088_() == 4;
    }

    protected void m_7856_() {
        this.createGameModeButton();
        this.createAllowCommandsButton();
        this.createPortEditBox();
        this.createMaxPlayersEditBox();
        this.createOpenToOnlineButton();
        this.createAdvancedSettingsButton();
        this.createRecreateFirewallRulesButton();
        this.createCancelButton();
    }

    public void m_86600_() {
        this.portEditBox.m_94120_();
        this.maxPlayersEditBox.m_94120_();
        if (this.portEditBox.m_93696_()) {
            this.maxPlayersEditBox.m_94178_(false);
        }
    }

    private void createRecreateFirewallRulesButton() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ / 4 + 69, 150, 20, (Component)Component.m_237115_((String)"gui.opentoonline.recreateFirewallRules"), p_96657_ -> minecraft.m_91152_((Screen)new RecreateFirewallRulesScreen(this)), (pButton, pPoseStack, pMouseX, pMouseY) -> this.m_96617_(pPoseStack, ShareToOnlineScreen.minecraft.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"tooltip.opentoonline.recreateFirewallRules"), 200), pMouseX, pMouseY)));
    }

    private void createAdvancedSettingsButton() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ / 4 + 69, 150, 20, (Component)Component.m_237115_((String)"gui.opentoonline.advancedSettings"), p_96657_ -> minecraft.m_91152_((Screen)new AdvancedSettingsScreen(this))));
    }

    private void createCancelButton() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 28, 150, 20, CommonComponents.f_130656_, p_96657_ -> minecraft.m_91152_(this.lastScreen)));
    }

    private void createOpenToOnlineButton() {
        this.openToOnlineButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ - 28, 150, 20, (Component)Component.m_237115_((String)"gui.opentoonline.startOnlineWorld"), p_96660_ -> {
            minecraft.m_91152_(null);
            int port = Integer.parseInt(this.portEditBox.m_94155_());
            int maxPlayers = Integer.parseInt(this.maxPlayersEditBox.m_94155_());
            new Thread(() -> OpenToOnlineCommand.open(port, maxPlayers, this.gameMode, this.commands)).start();
        }));
    }

    private void createPortEditBox() {
        this.portEditBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 155 + 1, this.f_96544_ / 4 + 45, 148, 20, (Component)Component.m_237113_((String)""));
        this.portEditBox.m_94144_(this.initPort);
        this.portEditBox.m_94151_(pResponder -> {
            this.initPort = pResponder;
            this.openToOnlineButton.f_93623_ = this.isEditBoxesValuesValid();
        });
        this.m_142416_((GuiEventListener)this.portEditBox);
    }

    private void createMaxPlayersEditBox() {
        this.maxPlayersEditBox = new EditBox(this.f_96547_, this.f_96543_ / 2 + 5 + 1, this.f_96544_ / 4 + 45, 148, 20, (Component)Component.m_237113_((String)""));
        this.maxPlayersEditBox.m_94144_(this.initMaxPlayers);
        this.maxPlayersEditBox.m_94151_(pResponder -> {
            this.initMaxPlayers = pResponder;
            this.openToOnlineButton.f_93623_ = this.isEditBoxesValuesValid();
        });
        this.m_142416_((GuiEventListener)this.maxPlayersEditBox);
    }

    private void createAllowCommandsButton() {
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.commands).m_168936_(this.f_96543_ / 2 + 5, this.f_96544_ / 4 + 8, 150, 20, ALLOW_COMMANDS_LABEL, (p_169432_, p_169433_) -> {
            this.commands = p_169433_;
        }));
    }

    private void createGameModeButton() {
        this.m_142416_((GuiEventListener)CycleButton.m_168894_(GameType::m_151500_).m_168961_((Object[])new GameType[]{GameType.SURVIVAL, GameType.SPECTATOR, GameType.CREATIVE, GameType.ADVENTURE}).m_168948_((Object)this.gameMode).m_168936_(this.f_96543_ / 2 - 155, this.f_96544_ / 4 + 8, 150, 20, GAME_MODE_LABEL, (p_169429_, p_169430_) -> {
            this.gameMode = p_169430_;
        }));
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        ShareToOnlineScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(Math.max(52, this.f_96544_ / 4 - 8) - 22), (int)0xFFFFFF);
        ShareToOnlineScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)SETTINGS_INFO_TEXT, (int)(this.f_96543_ / 2), (int)Math.max(52, this.f_96544_ / 4 - 8), (int)0xFFFFFF);
        ShareToOnlineScreen.m_93243_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)PORT_INFO_TEXT, (int)this.portEditBox.f_93620_, (int)(this.portEditBox.f_93621_ - this.portEditBox.m_93694_() / 2 - 1), (int)0xFFFFFF);
        ShareToOnlineScreen.m_93243_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)MAX_PLAYERS_INFO_TEXT, (int)this.maxPlayersEditBox.f_93620_, (int)(this.maxPlayersEditBox.f_93621_ - this.maxPlayersEditBox.m_93694_() / 2 - 1), (int)0xFFFFFF);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private boolean isEditBoxesValuesValid() {
        try {
            int port = Integer.parseInt(this.portEditBox.m_94155_());
            int maxPlayers = Integer.parseInt(this.maxPlayersEditBox.m_94155_());
            return port >= 0 && port <= 65535 && maxPlayers > 0;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

