/*
 * Decompiled with CFR 0.152.
 */
package xilef11.mc.realtimeclock.client.gui;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import xilef11.mc.realtimeclock.handler.ConfigurationHandler;
import xilef11.mc.realtimeclock.utilities.RenderingPosHelper;

public class Clock {
    private static boolean enabled = true;
    private static int xPos = -1;
    private static int yPos = -1;
    private static boolean wasFullScreen = false;
    private static Calendar time = null;

    public static void toggleEnabled() {
        boolean bl = enabled = !enabled;
        if (!enabled) {
            Clock.resetPosition();
        }
    }

    public static void resetPosition() {
        yPos = -1;
        xPos = -1;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean doesRender(Minecraft mc) {
        if (mc.field_71441_e == null) {
            return false;
        }
        return enabled;
    }

    public static void draw(Minecraft mc) {
        boolean fullscreen = Display.isFullscreen();
        if (wasFullScreen && !fullscreen || !wasFullScreen && fullscreen) {
            wasFullScreen = fullscreen;
            Clock.resetPosition();
        }
        if (xPos < 0 || yPos < 0 || Display.wasResized()) {
            xPos = RenderingPosHelper.getXPosByScreenSize(mc, ConfigurationHandler.clockPosX);
            yPos = RenderingPosHelper.getYPosByScreenSize(mc, ConfigurationHandler.clockPosY);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)ConfigurationHandler.clockScale, (float)ConfigurationHandler.clockScale, (float)1.0f);
        boolean lightingState = GL11.glIsEnabled((int)2896);
        if (lightingState) {
            GL11.glDisable((int)2896);
        }
        mc.field_71466_p.func_175065_a(Clock.getTimeString(mc), (float)Math.round((float)xPos / ConfigurationHandler.clockScale), (float)Math.round((float)yPos / ConfigurationHandler.clockScale), ConfigurationHandler.color, ConfigurationHandler.drawShadow);
        if (lightingState) {
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
    }

    private static String getTimeString(Minecraft mc) {
        if (time == null) {
            time = Calendar.getInstance(TimeZone.getDefault(), Locale.forLanguageTag(mc.field_71474_y.field_74363_ab));
        } else {
            time.setTimeInMillis(System.currentTimeMillis());
        }
        int hour = ConfigurationHandler.use24hours ? time.get(11) : time.get(10);
        int minute = time.get(12);
        String minuteS = minute < 10 ? "0" + minute : String.valueOf(minute);
        return hour + " : " + minuteS;
    }

    private static boolean drawShadow(Minecraft mc) {
        return ConfigurationHandler.drawShadow;
    }
}

