/*
 * Decompiled with CFR 0.152.
 */
package xilef11.mc.realtimeclock.client.gui;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import xilef11.mc.realtimeclock.handler.ConfigurationHandler;
import xilef11.mc.realtimeclock.utilities.RenderingPosHelper;

public class Clock {
    private static boolean enabled = true;

    public static void toggleEnabled() {
        enabled = !enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean doesRender(Minecraft mc) {
        if (mc.field_71441_e == null) {
            return false;
        }
        return enabled;
    }

    public static void draw(Minecraft mc) {
        int xPos = RenderingPosHelper.getXPosByScreenSize(mc, ConfigurationHandler.clockPosX);
        int yPos = RenderingPosHelper.getYPosByScreenSize(mc, ConfigurationHandler.clockPosY);
        float scale = ConfigurationHandler.clockScale / 100.0f;
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        boolean lightingState = GL11.glIsEnabled((int)2896);
        if (lightingState) {
            GL11.glDisable((int)2896);
        }
        mc.field_71466_p.func_85187_a(Clock.getTimeString(mc), Math.round((float)xPos / scale), Math.round((float)yPos / scale), ConfigurationHandler.color, Clock.drawShadow(mc));
        if (lightingState) {
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
    }

    private static String getTimeString(Minecraft mc) {
        Calendar time = Calendar.getInstance(TimeZone.getDefault(), Locale.forLanguageTag(mc.field_71474_y.field_74363_ab));
        int hour = ConfigurationHandler.use24hours ? time.get(11) : time.get(10);
        int minute = time.get(12);
        String minuteS = minute < 10 ? "0" + minute : String.valueOf(minute);
        return hour + " : " + minuteS;
    }

    private static boolean drawShadow(Minecraft mc) {
        return ConfigurationHandler.drawShadow;
    }
}

