/*
 * Decompiled with CFR 0.152.
 */
package xilef11.mc.realtimeclock.handler;

import java.io.File;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import xilef11.mc.realtimeclock.utilities.ModLogger;

public class ConfigurationHandler {
    public static Configuration config;
    public static boolean use24hours;
    public static float clockPosX;
    public static float clockPosY;
    public static float clockScale;
    public static int color;
    public static boolean drawShadow;
    public static boolean display;
    public static final String CATEGORY_VALUES = "stored values";

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("realtimeclock")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        use24hours = config.getBoolean("use24hours", "general", true, "Set to false to use a 12-hour clock");
        clockPosX = config.getFloat("posX", "general", 0.5f, 0.0f, 100.0f, "Horizontal (X) position of the Clock HUD (as % of screen size)\nA too large value will be off screen");
        clockPosY = config.getFloat("posY", "general", 95.0f, 0.0f, 100.0f, "Vertical (Y) position of the Clock HUD (as % of screen size)\nA too large value will be off screen");
        clockScale = config.getFloat("clockScale", "general", 120.0f, 0.0f, Float.MAX_VALUE, "The Size of the clock (in % of the standard MC String size)");
        Pattern hexCol = Pattern.compile("[0-9[A-F]]{6}?");
        String col = config.getString("color", "general", "AAAAAA", "Colour of the clock display, in Hexadecimal (from 0 to F for each of RRGGBB)", hexCol);
        try {
            color = Integer.parseInt(col, 16);
        }
        catch (NumberFormatException e) {
            ModLogger.logException(Level.WARN, e, "Wrong Color String");
        }
        drawShadow = config.getBoolean("drawShadow", "general", true, "Set to false to disable drawing the Shadow of the clock (recommended for dark colors)");
        config.addCustomCategoryComment(CATEGORY_VALUES, "This section is used to store values between reloads");
        display = config.getBoolean("displayClock", CATEGORY_VALUES, true, "is the clock displayed?");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void setValueDisplay(boolean b) {
        config.getCategory(CATEGORY_VALUES).get("displayClock").set(b);
        config.save();
    }

    static {
        use24hours = true;
    }
}

