/*
 * Decompiled with CFR 0.152.
 */
package com.mindstorm3223.songsofwarmod.network;

import com.mindstorm3223.songsofwarmod.network.PacketBase;
import com.mindstorm3223.songsofwarmod.util.TPBeaconWorldSaveData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketUpdateName
extends PacketBase<PacketUpdateName> {
    public int worldId;
    public int changeId;
    public String changeTo;

    public PacketUpdateName() {
    }

    public PacketUpdateName(int worldId, int changeId, String changeTo) {
        this.worldId = worldId;
        this.changeId = changeId;
        this.changeTo = changeTo;
    }

    public void fromBytes(ByteBuf buf) {
        this.worldId = buf.readInt();
        this.changeId = buf.readInt();
        this.changeTo = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.worldId);
        buf.writeInt(this.changeId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.changeTo);
    }

    @Override
    public void handleClientSide(PacketUpdateName message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketUpdateName message, EntityPlayer player) {
        WorldServer world = DimensionManager.getWorld((int)message.worldId);
        TPBeaconWorldSaveData.get((World)world).saveName(message.changeId, message.changeTo);
    }
}

