/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod;

import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.config.ModConfigManager;
import com.branders.spawnermod.event.SpawnerEventHandler;
import com.branders.spawnermod.networking.SpawnerModPacketHandler;
import com.branders.spawnermod.networking.packet.SyncSpawnerConfig;
import com.branders.spawnermod.registry.RegistryHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="spawnermod")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpawnerMod {
    public static final String MOD_ID = "spawnermod";
    public static final Logger LOGGER = LogManager.getLogger((String)"spawnermod");

    public SpawnerMod() {
        ModConfigManager.initConfig(MOD_ID, FMLPaths.CONFIGDIR.get());
        SpawnerModPacketHandler.register();
        RegistryHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new SpawnerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        SpawnerModPacketHandler.INSTANCE.sendTo((Object)new SyncSpawnerConfig(ConfigValues.get("disable_spawner_config"), ConfigValues.get("disable_count"), ConfigValues.get("disable_speed"), ConfigValues.get("disable_range")), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        SpawnerMod.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)((Item)new BlockItem(Blocks.f_50085_, new Item.Properties().m_41491_(CreativeModeTab.f_40750_).m_41497_(Rarity.EPIC)).setRegistryName(Blocks.f_50085_.getRegistryName())));
    }
}

