/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.config;

import com.branders.spawnermod.SpawnerMod;
import com.branders.spawnermod.config.ConfigValues;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;

public class ModConfigManager {
    private static File file;
    public static final Gson GSON;

    public static void initConfig(String modid, Path configPath) {
        ConfigValues.setDefaultConfigValues();
        SpawnerMod.LOGGER.info("Config path: [" + configPath.toFile() + "]");
        file = new File(configPath.toFile(), modid + ".json");
        if (!file.exists()) {
            SpawnerMod.LOGGER.info("Could not find config, generating new default config.");
            ModConfigManager.saveConfig();
        } else {
            SpawnerMod.LOGGER.info("Reading config values from file.");
            ModConfigManager.readConfig();
        }
    }

    private static void readConfig() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            Pair<JsonObject, Boolean> validConfig = ModConfigManager.validateConfig(json);
            JsonObject entities = json.getAsJsonObject("disable_specific_egg_drops");
            for (String key : ConfigValues.getKeys()) {
                if (json.get(key) != null) {
                    ConfigValues.put(key, json.get(key).getAsInt());
                    continue;
                }
                if (entities.get(key) != null) {
                    ConfigValues.put(key, entities.get(key).getAsInt());
                    continue;
                }
                SpawnerMod.LOGGER.warn("Key error: Could not find key: " + key);
            }
            if (validConfig.getRight().booleanValue()) {
                SpawnerMod.LOGGER.info("Config was broken. Saving new config which is fixed!");
                ModConfigManager.saveConfig();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void saveConfig() {
        JsonObject config = new JsonObject();
        Object[] keys = ConfigValues.getKeys().toArray();
        Arrays.sort(keys);
        JsonObject entities = new JsonObject();
        for (Object key : keys) {
            if (((String)key).matches("\\w+:\\w+")) {
                entities.addProperty((String)key, (Number)ConfigValues.get((String)key));
                continue;
            }
            config.addProperty((String)key, (Number)ConfigValues.get((String)key));
        }
        config.add("disable_specific_egg_drops", (JsonElement)entities);
        String jsonConfig = GSON.toJson((JsonElement)config);
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(jsonConfig);
            writer.close();
        }
        catch (IOException e) {
            SpawnerMod.LOGGER.warn("Could not save config file.");
            e.printStackTrace();
        }
    }

    private static Pair<JsonObject, Boolean> validateConfig(JsonObject json) {
        boolean brokenConfig = false;
        if (json.getAsJsonObject("disable_specific_egg_drops") == null) {
            SpawnerMod.LOGGER.info("Broken config. Group key=disable_specific_egg_drops was not found. Adding it and all its children ...");
            JsonObject entities = new JsonObject();
            for (Object k : ConfigValues.getKeys().toArray()) {
                if (!((String)k).matches("\\w+:\\w+")) continue;
                entities.addProperty((String)k, (Number)0);
            }
            json.add("disable_specific_egg_drops", (JsonElement)entities);
        }
        for (String key : ConfigValues.getKeys()) {
            JsonElement elem = json.get(key);
            if (key.matches("\\w+:\\w+")) {
                elem = json.getAsJsonObject("disable_specific_egg_drops").get(key);
            }
            if (elem != null) continue;
            SpawnerMod.LOGGER.info("Broken config. Key=" + key + " was not found. Adding it ...");
            brokenConfig = true;
            json.addProperty(key, (Number)ConfigValues.get(key));
        }
        return new Pair<JsonObject, Boolean>(json, brokenConfig);
    }

    static {
        GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    }

    static class Pair<L, R> {
        private final L left;
        private final R right;

        public Pair(L left, R right) {
            assert (left != null);
            assert (right != null);
            this.left = left;
            this.right = right;
        }

        public L getLeft() {
            return this.left;
        }

        public R getRight() {
            return this.right;
        }
    }
}

