/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.mixin;

import com.branders.spawnermod.config.ConfigValues;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseSpawner.class})
public class LimitedSpawnsMixin {
    private short spawns = 0;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;levelEvent(ILnet/minecraft/core/BlockPos;I)V")}, method={"serverTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V"}, cancellable=true)
    private void entitySpawn(ServerLevel level, BlockPos pos, CallbackInfo ci) {
        if (ConfigValues.get("limited_spawns_enabled") == 0) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        nbt = ((BaseSpawner)this).m_186381_(nbt);
        String entity_string = nbt.m_128423_("SpawnData").toString();
        entity_string = entity_string.substring(entity_string.indexOf("\"") + 1);
        if ((entity_string = entity_string.substring(0, entity_string.indexOf("\""))).contains("area_effect_cloud")) {
            return;
        }
        this.spawns = (short)(this.spawns + 1);
    }

    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/EntityType;by(Lnet/minecraft/nbt/CompoundTag;)Ljava/util/Optional;")}, method={"serverTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V"}, cancellable=true)
    private void cancel(ServerLevel level, BlockPos pos, CallbackInfo ci) {
        if (ConfigValues.get("limited_spawns_enabled") == 0) {
            return;
        }
        level.m_7702_(pos).m_6596_();
        level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 3);
        if (this.spawns >= ConfigValues.get("limited_spawns_amount")) {
            BaseSpawner logic = (BaseSpawner)this;
            CompoundTag nbt = new CompoundTag();
            nbt = logic.m_186381_(nbt);
            nbt.m_128376_("RequiredPlayerRange", (short)0);
            logic.m_151328_((Level)level, pos, nbt);
            logic.m_45462_(EntityType.f_20476_);
            level.m_46796_(1501, pos, 0);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;getShort(Ljava/lang/String;)S")}, method={"load"})
    private void load(Level level, BlockPos pos, CompoundTag nbt, CallbackInfo info) {
        if (ConfigValues.get("limited_spawns_enabled") == 0) {
            return;
        }
        this.spawns = nbt.m_128448_("spawns");
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putShort(Ljava/lang/String;S)V")}, method={"save"})
    private void save(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> info) {
        if (ConfigValues.get("limited_spawns_enabled") == 0) {
            return;
        }
        nbt.m_128376_("spawns", this.spawns);
    }
}

