/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.mixin;

import com.branders.spawnermod.config.ConfigValues;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseSpawner.class})
public class SpawnerRangeMixin {
    private boolean rangeSet = false;

    @Inject(at={@At(value="HEAD")}, method={"isNearPlayer(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z"}, cancellable=true)
    private void isNearPlayer(Level level, BlockPos spawner, CallbackInfoReturnable<Boolean> cir) {
        if (ConfigValues.get("default_spawner_range_enabled") == 1) {
            if (this.rangeSet) {
                return;
            }
            int range = ConfigValues.get("default_spawner_range");
            BaseSpawner logic = (BaseSpawner)this;
            CompoundTag nbt = new CompoundTag();
            nbt = logic.m_186381_(nbt);
            nbt.m_128376_("RequiredPlayerRange", (short)range);
            logic.m_151328_(level, spawner, nbt);
            this.rangeSet = true;
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;getShort(Ljava/lang/String;)S")}, method={"load"})
    private void load(Level level, BlockPos pos, CompoundTag nbt, CallbackInfo info) {
        if (ConfigValues.get("default_spawner_range_enabled") == 0) {
            return;
        }
        this.rangeSet = nbt.m_128471_("RangeSet");
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putShort(Ljava/lang/String;S)V")}, method={"save"})
    private void save(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> info) {
        if (ConfigValues.get("default_spawner_range_enabled") == 0) {
            return;
        }
        nbt.m_128379_("RangeSet", this.rangeSet);
    }
}

