/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.client;

import com.github.ipixeli.gender.Gender;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class Config {
    protected static Config instance;
    private File suchFile;
    public boolean priorityModeClient = true;
    public boolean enableChatColors = false;
    public boolean enablePlayerGenders = false;
    public boolean enablePlayerChildren = false;
    public boolean enablePlayerGenderSounds = false;
    public boolean defaultSettingPlayerGenderFemale = false;
    public boolean defaultSettingPlayerAgeChild = false;
    public byte defaultSettingPlayerModel = (byte)2;
    public boolean enableZombieGenders = false;
    public byte settingZombieModel = 1;

    public Config(File veryDir) {
        instance = this;
        Gender.logInfo(this.getClass().getSimpleName() + " initilized");
        this.suchFile = new File(veryDir, "gender.cfg");
        this.defaults();
        if (!this.suchFile.exists()) {
            try {
                this.suchFile.createNewFile();
            }
            catch (IOException e) {
                Gender.logErr("Failed to create or locate file " + this.suchFile.getName() + " with error: " + e.getMessage());
            }
        }
        Gender.logInfo(this.suchFile.getAbsolutePath());
        this.readList();
    }

    public static Config config() {
        return instance;
    }

    public void defaults() {
        this.priorityModeClient = true;
        this.enableChatColors = false;
        this.enablePlayerGenders = true;
        this.enablePlayerChildren = true;
        this.enablePlayerGenderSounds = true;
        this.enableZombieGenders = true;
        this.settingZombieModel = 1;
        this.defaultSettingPlayerGenderFemale = false;
        this.defaultSettingPlayerAgeChild = false;
    }

    private void readList() {
        try {
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.suchFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                String[] t = s.split("=");
                if (t[0].equals("enableClientPriority")) {
                    this.priorityModeClient = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enableChatColors")) {
                    this.enableChatColors = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enablePlayerGenders")) {
                    this.enablePlayerGenders = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enablePlayerChildren")) {
                    this.enablePlayerChildren = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enablePlayerGenderSounds")) {
                    this.enablePlayerGenderSounds = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("defaultSettingPlayerGenderFemale")) {
                    this.defaultSettingPlayerGenderFemale = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("defaultSettingPlayerAgeChild")) {
                    this.defaultSettingPlayerAgeChild = t[1].equals("true");
                    continue;
                }
                if (t[0].equals("enableZombieGenders")) {
                    this.enableZombieGenders = t[1].equals("true");
                    continue;
                }
                if (!t[0].equals("settingZombieModel")) continue;
                this.settingZombieModel = Byte.parseByte(t[1]);
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            Gender.logErr("Failed to load modification settings: " + exception);
            this.saveList();
        }
    }

    private void saveList() {
        try {
            PrintWriter printwriter = new PrintWriter((Writer)new FileWriter(this.suchFile), false);
            printwriter.println("enableClientPriority=" + this.priorityModeClient);
            printwriter.println("enableChatColors=" + this.enableChatColors);
            printwriter.println("enablePlayerGenders=" + this.enablePlayerGenders);
            printwriter.println("enablePlayerChildren=" + this.enablePlayerChildren);
            printwriter.println("enablePlayerGenderSounds=" + this.enablePlayerGenderSounds);
            printwriter.println("defaultSettingPlayerGenderFemale=" + this.defaultSettingPlayerGenderFemale);
            printwriter.println("defaultSettingPlayerAgeChild=" + this.defaultSettingPlayerAgeChild);
            printwriter.println("enableZombieGenders=" + this.enableZombieGenders);
            printwriter.println("settingZombieModel=" + this.settingZombieModel);
            printwriter.close();
        }
        catch (Exception exception) {
            Gender.logErr("Failed to save modification settings: " + exception);
        }
    }

    public void updateConfig() {
        this.saveList();
    }

    public boolean isEnablePlayerGenders() {
        return this.enablePlayerGenders;
    }

    public boolean isPlayerChildrenEnabled() {
        return this.enablePlayerChildren;
    }

    public boolean priorityMode() {
        return this.priorityModeClient;
    }
}

