/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.client;

import com.github.ipixeli.gender.client.Config;
import com.github.ipixeli.gender.client.ModelParts;
import com.github.ipixeli.gender.common.PlayerSettingLogic;
import com.mojang.authlib.GameProfile;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderHooks {
    private static HashMap<ModelBiped, ModelParts> models = new HashMap();
    public static final ResourceLocation texFemaleC = new ResourceLocation("gender", "textures/entity/charfemalechild.png");
    public static final ResourceLocation texFemale = new ResourceLocation("gender", "textures/entity/charfemale.png");
    public static final ResourceLocation texMaleC = new ResourceLocation("gender", "textures/entity/charmalechild.png");
    public static final ResourceLocation texMale = new ResourceLocation("minecraft", "textures/entity/steve.png");
    public static final ResourceLocation texFemaleZC = new ResourceLocation("gender", "textures/entity/zombiefemalechild.png");
    public static final ResourceLocation texFemaleZ = new ResourceLocation("gender", "textures/entity/zombiefemale.png");
    public static final ResourceLocation texMaleZC = new ResourceLocation("gender", "textures/entity/zombiemalechild.png");
    public static final ResourceLocation texMaleZ = new ResourceLocation("minecraft", "textures/entity/zombie/zombie.png");
    private static final ResourceLocation zombiePigmanTextures = new ResourceLocation("textures/entity/zombie_pigman.png");
    private static final ResourceLocation zombieTextures = new ResourceLocation("textures/entity/zombie/zombie.png");
    private static final ResourceLocation zombieVillagerTextures = new ResourceLocation("textures/entity/zombie/zombie_villager.png");
    private static final ResourceLocation ZOMBIE_TEXTURES = new ResourceLocation("textures/entity/zombie/zombie.png");
    private static final ResourceLocation texHusk = new ResourceLocation("textures/entity/zombie/husk.png");

    public static void init(ModelBiped instance) {
        models.put(instance, new ModelParts(instance));
    }

    public static void setRotations(ModelBiped instance) {
        models.get(instance).setRotations(instance.field_78115_e);
    }

    public static void render(ModelBiped instance, Entity entity, float f) {
        EntityPlayer p;
        if (entity instanceof EntityZombie && !RenderHooks.hasArmorEntity((EntityLivingBase)entity) && !(entity instanceof EntityPigZombie)) {
            if (RenderHooks.isZombieFemale(entity.func_145782_y()) && !((EntityZombie)entity).func_70631_g_()) {
                if (entity.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                }
                models.get(instance).render(f, Config.config().settingZombieModel);
            }
        } else if (entity instanceof EntityPlayer && !RenderHooks.hasArmorEntity((EntityLivingBase)(p = (EntityPlayer)entity)) && PlayerSettingLogic.getIsDisplayedAsFemale(p.getDisplayNameString()) && !PlayerSettingLogic.getIsDisplayedAsChild(p.getDisplayNameString())) {
            if (entity.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            models.get(instance).render(f, PlayerSettingLogic.getIsDisplayedModel(p.getDisplayNameString()));
        }
    }

    public static void renderGenderLayer(ModelBiped instance, EntityPlayer e, float f) {
        if (PlayerSettingLogic.getIsDisplayedAsFemale(e.getDisplayNameString()) && !PlayerSettingLogic.getIsDisplayedAsChild(e.getDisplayNameString()) && !RenderHooks.hasArmorEntity((EntityLivingBase)e)) {
            models.get(instance).render(f, PlayerSettingLogic.getIsDisplayedModel(e.getDisplayNameString()));
        }
    }

    public static ResourceLocation getPlayerTexture(UUID uuid) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            GameProfile[] agameprofile = new GameProfile[Minecraft.func_71410_x().field_71441_e.field_73010_i.size()];
            for (int i = 0; i < Minecraft.func_71410_x().field_71441_e.field_73010_i.size(); ++i) {
                agameprofile[i] = ((EntityPlayer)Minecraft.func_71410_x().field_71441_e.field_73010_i.get(i)).func_146103_bH();
                if (agameprofile[i].getId() != uuid) continue;
                boolean isChild = PlayerSettingLogic.getIsDisplayedAsChild(agameprofile[i].getName());
                if (PlayerSettingLogic.getIsDisplayedAsFemale(agameprofile[i].getName())) {
                    return isChild ? texFemaleC : texFemale;
                }
                return isChild ? texMaleC : texMale;
            }
        }
        return texMale;
    }

    public static byte getNameHeight(Entity e) {
        return (byte)(e instanceof EntityPlayer ? (PlayerSettingLogic.getIsDisplayedAsChild(((EntityPlayer)e).getDisplayNameString()) ? (PlayerSettingLogic.getIsDisplayedAsFemale(((EntityPlayer)e).getDisplayNameString()) ? 10 : 13) : (PlayerSettingLogic.getIsDisplayedAsFemale(((EntityPlayer)e).getDisplayNameString()) ? 3 : 0)) : 0);
    }

    public static int getChatColor1(Entity e) {
        if (e instanceof EntityPlayer && Config.config().enableChatColors) {
            return PlayerSettingLogic.getIsDisplayedAsFemale(((EntityPlayer)e).getDisplayNameString()) ? 4134207 : 1392447;
        }
        return 0x20FFFFFF;
    }

    public static int getChatColor2(Entity e) {
        if (e instanceof EntityPlayer && Config.config().enableChatColors) {
            return PlayerSettingLogic.getIsDisplayedAsFemale(((EntityPlayer)e).getDisplayNameString()) ? 0xFF55FF : 0x55FFFF;
        }
        return -1;
    }

    public static void playerPreRenderCallback(AbstractClientPlayer entity, float f) {
        float var3 = 1.0f;
        if (Config.config().enablePlayerChildren && PlayerSettingLogic.getIsDisplayedAsChild(entity.getDisplayNameString())) {
            var3 = Config.config().enablePlayerGenders && PlayerSettingLogic.getIsDisplayedAsFemale(entity.getDisplayNameString()) ? 0.829546f : 0.786453f;
        } else if (Config.config().enablePlayerGenders && PlayerSettingLogic.getIsDisplayedAsFemale(entity.getDisplayNameString())) {
            var3 = 0.936f;
        }
        GL11.glScalef((float)var3, (float)var3, (float)var3);
        RenderHooks.tryValentinesDayEffect((EntityLivingBase)entity);
    }

    protected static boolean hasArmorEntity(EntityLivingBase entity) {
        for (ItemStack is : entity.func_184209_aF()) {
            if (is == null || !(is.func_77973_b() instanceof ItemArmor) || ((ItemArmor)is.func_77973_b()).field_77881_a != EntityEquipmentSlot.CHEST) continue;
            return true;
        }
        return false;
    }

    public static ResourceLocation getZombieTexture(EntityZombie entityZombie) {
        if (entityZombie instanceof EntityZombieVillager) {
            return zombieVillagerTextures;
        }
        if (entityZombie instanceof EntityHusk) {
            return texHusk;
        }
        boolean f = RenderHooks.isZombieFemale(entityZombie.func_145782_y());
        if (entityZombie.func_70631_g_()) {
            return f ? texFemaleZC : texMaleZC;
        }
        return f ? texFemaleZ : texMaleZ;
    }

    private static boolean isZombieFemale(double entityId) {
        if (entityId <= 0.0 || !Config.config().enableZombieGenders) {
            return false;
        }
        return entityId % 16.0 == 0.0;
    }

    private static void tryValentinesDayEffect(EntityLivingBase e) {
        boolean vday;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        boolean bl = vday = calendar.get(2) + 1 == 2 && calendar.get(5) == 14;
        if (e instanceof EntityPlayer) {
            Random rand;
            EntityPlayer jj = null;
            EntityPlayer pix = null;
            if (((EntityPlayer)e).func_146103_bH().getName().equals("jjw123")) {
                jj = (EntityPlayer)e;
            } else if (((EntityPlayer)e).func_146103_bH().getName().equals("iPixeli")) {
                pix = (EntityPlayer)e;
            }
            for (Object o : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
                if (!(o instanceof EntityPlayer)) continue;
                EntityPlayer p = (EntityPlayer)o;
                if (p.func_146103_bH().getName().equals("iPixeli") && jj != null) {
                    pix = p;
                    continue;
                }
                if (!p.func_146103_bH().getName().equals("jjw123") || pix == null) continue;
                jj = p;
            }
            boolean wuv = pix != null && jj != null ? RenderHooks.chkdst(jj.func_70032_d((Entity)pix)) : false;
            float dst = Minecraft.func_71410_x().field_71439_g.func_70032_d((Entity)e);
            if ((vday || wuv) && RenderHooks.chkdst(dst) && (rand = new Random()).nextInt((int)(5000.0f * (wuv ? jj.func_70032_d((Entity)pix) : dst))) < 100) {
                double d0 = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                Minecraft.func_71410_x().field_71438_f.func_180442_a(EnumParticleTypes.HEART.func_179348_c(), true, e.field_70165_t + (double)(rand.nextFloat() * e.field_70130_N * 2.0f) - (double)e.field_70130_N, e.field_70163_u + (e instanceof EntityOtherPlayerMP ? 0.5 : -1.0) + (double)(rand.nextFloat() * e.field_70131_O), e.field_70161_v + (double)(rand.nextFloat() * e.field_70130_N * 2.0f) - (double)e.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }

    private static boolean chkdst(float dst) {
        return (double)dst < 7.6 && (double)dst != 0.0;
    }
}

