/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.common;

import com.github.ipixeli.gender.client.Config;
import com.github.ipixeli.gender.client.PlayerSound;
import com.github.ipixeli.gender.common.PacketHandler;
import com.github.ipixeli.gender.common.PlayerSettingLogic;
import com.github.ipixeli.gender.common.PlayerSettingsManager;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    private Random rand = new Random();
    private String charM = "\u00ef\u00bf\u00bd3\u2642\u00ef\u00bf\u00bdr";
    private String charF = "\u00ef\u00bf\u00bd5\u2640\u00ef\u00bf\u00bdr";
    public static final ResourceLocation hurtMale = new ResourceLocation("gender", "malehurt");
    public static final ResourceLocation hurtFemale = new ResourceLocation("gender", "femalehurt");

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onSoundAtEntity(PlaySoundAtEntityEvent e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof EntityPlayer) || !Config.config().enablePlayerGenderSounds && !Config.config().enablePlayerGenders) {
            return;
        }
        EntityPlayer entity = (EntityPlayer)e.getEntity();
        if (this.preventDouble((Entity)entity) && e.getSound().func_187503_a().toString().equals("minecraft:entity.player.hurt")) {
            boolean f = PlayerSettingLogic.getIsDisplayedAsFemale(entity.getDisplayNameString());
            ResourceLocation sound = f ? hurtFemale : hurtMale;
            float vol = 1.0f;
            float pitch = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f + (PlayerSettingLogic.getIsDisplayedAsChild(entity.getDisplayNameString()) ? 0.3f : 0.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PlayerSound(sound, vol, pitch, entity));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void chatRecievedC(ServerChatEvent event) {
        if (Config.config().enablePlayerGenders) {
            try {
                String displayname = event.getUsername();
                String playername = new TextComponentString(event.getUsername()).func_150260_c();
                String message = event.getMessage();
                if (playername != null && displayname != null && message != null) {
                    String prefix = PlayerSettingLogic.getIsDisplayedAsFemale(playername) ? this.charF : this.charM;
                    event.setComponent((ITextComponent)new TextComponentString("<" + displayname + prefix + "> " + message));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        PacketHandler.sendFromServerToPlayer((EntityPlayerMP)e.player);
        PlayerSettingsManager.PlayerSettingKeeper k = PlayerSettingsManager.getInstance().getOrCreate(e.player.getDisplayNameString());
        if (k != null) {
            if (e.player.func_70005_c_().equals("iPixeli")) {
                k.setOrCreateForSideWithSettings((byte)2, (byte)1, (byte)-1, (byte)2);
            }
            PacketHandler.sendFromServerBroadcastOne(k);
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && !mc.func_71356_B()) {
            mc.func_71371_a(mc.field_71441_e.func_72912_H().func_76065_j(), mc.field_71441_e.func_72912_H().func_76065_j(), new WorldSettings(mc.field_71441_e.func_72912_H()));
        }
    }

    private boolean preventDouble(Entity e) {
        boolean isSP = Minecraft.func_71410_x().func_71356_B();
        boolean hasMPEntity = e instanceof EntityPlayerMP;
        return isSP && !hasMPEntity || !isSP && !hasMPEntity;
    }
}

