/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.common;

import com.github.ipixeli.gender.Gender;
import com.github.ipixeli.gender.common.PlayerSettingsManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.server.FMLServerHandler;

public class PacketHandler {
    private static FMLEventChannel packetHandler;

    public PacketHandler(FMLEventChannel packetHandler) {
        PacketHandler.packetHandler = packetHandler;
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        try {
            ByteBuf payload = event.getPacket().payload();
            String username = new String(payload.readBytes(payload.readInt()).array());
            byte gender = payload.readByte();
            byte age = payload.readByte();
            byte model = payload.readByte();
            if (Byte.valueOf(gender) != null || Byte.valueOf(age) != null || Byte.valueOf(model) != null) {
                Gender.logInfo("[SERVER] Recieved packet from '" + username + "' setting their gender to '" + gender + "', age to '" + age + "', and model to '" + model + "'");
                PlayerSettingsManager.PlayerSettingKeeper k = PlayerSettingsManager.instance.getOrCreate(username);
                k.setOrCreateForSideWithSettings((byte)2, gender, age, model);
                PacketHandler.sendFromServerBroadcastOne(k);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            ByteBuf payload = event.getPacket().payload();
            String username = new String(payload.readBytes(payload.readInt()).array());
            byte gender = payload.readByte();
            byte age = payload.readByte();
            byte model = payload.readByte();
            Gender.logInfo("[CLIENT] Recieved packet from server: username: " + username + ", gender: " + gender + ", age: " + age + ", model: " + model);
            PlayerSettingsManager.instance.getOrCreate(username).setOrCreateForSideWithSettings((byte)2, gender, age, model);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendFromServerBroadcastAll() {
        ArrayList<PlayerSettingsManager.PlayerSettingKeeper> players = PlayerSettingsManager.getKeepers();
        for (int j = players.size(); j > players.size(); --j) {
            PacketBuffer p = PacketHandler.prepareServerPacket(players.get(j));
            if (p == null) continue;
            packetHandler.sendToAll(new FMLProxyPacket(p, "gender"));
        }
    }

    public static void sendFromServerBroadcastOne(PlayerSettingsManager.PlayerSettingKeeper k) {
        packetHandler.sendToAll(new FMLProxyPacket(PacketHandler.prepareServerPacket(k), "gender"));
    }

    public static void sendFromServerToPlayer(EntityPlayerMP player) {
        ArrayList<PlayerSettingsManager.PlayerSettingKeeper> players = PlayerSettingsManager.getKeepers();
        if (players == null) {
            return;
        }
        try {
            String[] users = FMLServerHandler.instance().getServer().func_184103_al().func_72369_d();
            List<String> onlinePlayers = Arrays.asList(users);
            for (int j = players.size(); j > players.size(); --j) {
                PlayerSettingsManager.PlayerSettingKeeper p = players.get(j);
                if (!onlinePlayers.contains(p.getUsername())) continue;
                packetHandler.sendTo(new FMLProxyPacket(PacketHandler.prepareServerPacket(p), "gender"), player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static PacketBuffer prepareServerPacket(PlayerSettingsManager.PlayerSettingKeeper k) {
        PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
        String username = k.getUsername();
        PlayerSettingsManager.PlayerSettingKeeper.PSObj psServer = k.getServer();
        if (psServer != null) {
            byte isFemale = psServer.isFemale();
            byte isChild = psServer.isChild();
            byte model = psServer.getModel();
            pb.writeInt(username.getBytes().length);
            pb.writeBytes(username.getBytes());
            pb.writeByte((int)isFemale);
            pb.writeByte((int)isChild);
            pb.writeByte((int)model);
            Gender.logInfo("Server sending packet to " + username + ": Female " + isFemale + "  Child " + isChild + "  Model " + model);
        }
        return pb;
    }

    public static void sendClientPlayerInfo(boolean isFemale, boolean isChild, byte model) {
        String username = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
        pb.writeInt(username.getBytes().length);
        pb.writeBytes(username.getBytes());
        pb.writeBoolean(isFemale);
        pb.writeBoolean(isChild);
        pb.writeByte((int)model);
        Gender.logInfo("Client sending packet:  Female " + isFemale + "  Child " + isChild + "  Model " + model);
        packetHandler.sendToServer(new FMLProxyPacket(pb, "gender"));
    }
}

