/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.coremod;

import com.github.ipixeli.gender.coremod.CoreWatcher;
import com.github.ipixeli.gender.coremod.Mapping;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@IFMLLoadingPlugin.Name(value="GenderCore")
@IFMLLoadingPlugin.MCVersion(value="2")
public class GenderClassTransformer
implements IClassTransformer {
    private static final String prefix = "[Gender][GENDERCORE]";
    private static final Mapping<String, String> c_ResourceLocation = new Mapping("net/minecraft/util/ResourceLocation", "nf");
    private static final Mapping<String, String> c_RenderZombie = new Mapping("net.minecraft.client.renderer.entity.RenderZombie", "cbn");
    private static final Mapping<String, String> m_getEntityTexture = new Mapping("getEntityTexture", "a");
    private static final Mapping<String, String> c_EntityZombie = new Mapping("net/minecraft/entity/monster/EntityZombie", "adt");
    private static final Mapping<String, String> c_DefaultPlayerSkin = new Mapping("net.minecraft.client.resources.DefaultPlayerSkin", "cef");
    private static final Mapping<String, String> m_getDefaultSkin = new Mapping("getDefaultSkin", "a");
    private static final Mapping<String, String> c_RenderPlayer = new Mapping("net.minecraft.client.renderer.entity.RenderPlayer", "cct");
    private static final Mapping<String, String> m_preRenderCallback = new Mapping("preRenderCallback", "a");
    private static final Mapping<String, String> c_AbstractClientPlayer = new Mapping("net/minecraft/client/entity/AbstractClientPlayer", "bua");
    private static final Mapping<String, String> c_EntityLivingBase = new Mapping("net/minecraft/entity/EntityLivingBase", "vp");
    private static final Mapping<String, String> c_ModelPlayer = new Mapping("net.minecraft.client.model.ModelPlayer", "bqj");
    private static final Mapping<String, String> c_ModelRenderer = new Mapping("net/minecraft/client/model/ModelRenderer", "brs");
    private static final Mapping<String, String> c_ModelBiped = new Mapping("net/minecraft/client/model/ModelBiped", "bpx");
    private static final Mapping<String, String> f_bipedBody = new Mapping("bipedBody", "g");
    private static final Mapping<String, String> c_Entity = new Mapping("net/minecraft/entity/Entity", "vg");
    private static final Mapping<String, String> m_setRotationAngles = new Mapping("setRotationAngles", "a");
    private static final Mapping<String, String> m_render = new Mapping("render", "a");

    public GenderClassTransformer() {
        CoreWatcher.recordCoreWasCalled();
        System.out.println("[Gender][GENDERCORE]TRANSFORMER INIT!");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.equals(GenderClassTransformer.c_RenderPlayer.obf)) {
            return this.patch_playerScale(basicClass, true);
        }
        if (name.equals(GenderClassTransformer.c_RenderPlayer.unobf)) {
            System.out.println("[Gender][GENDERCORE]Patching class: " + name);
            return this.patch_playerScale(basicClass, false);
        }
        if (name.equals(GenderClassTransformer.c_RenderZombie.obf)) {
            return this.patch_zombieTexture(basicClass, true);
        }
        if (name.equals(GenderClassTransformer.c_RenderZombie.unobf)) {
            System.out.println("[Gender][GENDERCORE]Patching class: " + name);
            return this.patch_zombieTexture(basicClass, false);
        }
        if (name.equals(GenderClassTransformer.c_DefaultPlayerSkin.obf)) {
            return this.patch_playerTexture(basicClass, true);
        }
        if (name.equals(GenderClassTransformer.c_DefaultPlayerSkin.unobf)) {
            System.out.println("[Gender][GENDERCORE]Patching class: " + name);
            return this.patch_playerTexture(basicClass, false);
        }
        if (name.equals(GenderClassTransformer.c_ModelPlayer.obf)) {
            return this.patch_playerModel(basicClass, true);
        }
        if (name.equals(GenderClassTransformer.c_ModelPlayer.unobf)) {
            System.out.println("[Gender][GENDERCORE]Patching class: " + name);
            return this.patch_playerModel(basicClass, false);
        }
        return basicClass;
    }

    public byte[] patch_playerModel(byte[] bytes, boolean isObf) {
        String cEntity = c_Entity.get(isObf);
        String cBipedModel = c_ModelBiped.get(isObf);
        String cModelRenderer = c_ModelRenderer.get(isObf);
        String cPlayerModel = c_ModelPlayer.get(isObf).replaceAll("\\.", "/");
        String fBodyBiped = f_bipedBody.get(isObf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        classNode.methods.iterator();
        int PATCHED = 0;
        classNode.fields.add(new FieldNode(1, "cynthia", "L" + cModelRenderer + ";", "L" + cModelRenderer + ";", null));
        classNode.fields.add(new FieldNode(1, "stephanie", "L" + cModelRenderer + ";", "L" + cModelRenderer + ";", null));
        for (MethodNode m : classNode.methods) {
            InsnList toInject;
            AbstractInsnNode targetInst;
            if (m.name.equals("<init>") && m.desc.equals("(FZ)V")) {
                System.out.println("[Gender][GENDERCORE]Found method " + m.name + m.desc);
                targetInst = this.finalReturn(m);
                if (targetInst == null) continue;
                toInject = new InsnList();
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/ipixeli/gender/client/Model", "initC", "(L" + cBipedModel + ";)L" + cModelRenderer + ";", false));
                toInject.add((AbstractInsnNode)new FieldInsnNode(181, cPlayerModel, "cynthia", "L" + cModelRenderer + ";"));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/ipixeli/gender/client/Model", "initS", "(L" + cBipedModel + ";)L" + cModelRenderer + ";", false));
                toInject.add((AbstractInsnNode)new FieldInsnNode(181, cPlayerModel, "stephanie", "L" + cModelRenderer + ";"));
                m.instructions.insertBefore(targetInst, toInject);
                ++PATCHED;
                if (isObf) continue;
                System.out.println("[Gender][GENDERCORE]Patched ModelPlayer." + m.name + m.desc);
                continue;
            }
            if (m.name.equals(m_render.get(isObf)) && m.desc.equals("(L" + cEntity + ";FFFFFF)V")) {
                System.out.println("[Gender][GENDERCORE]Found method " + m.name + m.desc);
                targetInst = this.lastInvokeStatic(m);
                if (targetInst == null) continue;
                toInject = new InsnList();
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new FieldInsnNode(180, cPlayerModel, fBodyBiped, "L" + cModelRenderer + ";"));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new FieldInsnNode(180, cPlayerModel, "cynthia", "L" + cModelRenderer + ";"));
                toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInject.add((AbstractInsnNode)new FieldInsnNode(180, cPlayerModel, "stephanie", "L" + cModelRenderer + ";"));
                toInject.add((AbstractInsnNode)new VarInsnNode(23, 7));
                toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/ipixeli/gender/client/Renders", "onEvent", "(L" + cEntity + ";L" + cModelRenderer + ";L" + cModelRenderer + ";L" + cModelRenderer + ";F)V", false));
                m.instructions.insertBefore(targetInst, toInject);
                ++PATCHED;
                System.out.println("[Gender][GENDERCORE]Patched method " + m.name + m.desc);
                continue;
            }
            if (!m.name.equals(m_setRotationAngles.get(isObf)) || !m.desc.equals("(FFFFFFL" + cEntity + ";)V")) continue;
            System.out.println("[Gender][GENDERCORE]Found method " + m.name + m.desc);
            targetInst = this.finalReturn(m);
            if (targetInst == null) continue;
            toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, cPlayerModel, fBodyBiped, "L" + cModelRenderer + ";"));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, cPlayerModel, "cynthia", "L" + cModelRenderer + ";"));
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new FieldInsnNode(180, cPlayerModel, "stephanie", "L" + cModelRenderer + ";"));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/ipixeli/gender/client/Renders", "onEvent", "(L" + cModelRenderer + ";L" + cModelRenderer + ";L" + cModelRenderer + ";)V", false));
            m.instructions.insertBefore(targetInst, toInject);
            ++PATCHED;
            System.out.println("[Gender][GENDERCORE]Patched method " + m.name + m.desc);
        }
        if (PATCHED == 3) {
            CoreWatcher.PLAYER_MODEL.b = true;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private AbstractInsnNode lastInvokeStatic(MethodNode m) {
        AbstractInsnNode targetInst = null;
        for (int i = m.instructions.size() - 1; i >= 0; --i) {
            AbstractInsnNode instruction = m.instructions.get(i);
            AbstractInsnNode instructionBefore = m.instructions.get(i);
            if (instruction.getOpcode() != 184) continue;
            targetInst = instructionBefore;
            break;
        }
        if (targetInst == null) {
            System.out.println("Failed to find last INVOKESTATIC " + m.name + m.desc);
        }
        return targetInst;
    }

    private AbstractInsnNode finalReturn(MethodNode m) {
        AbstractInsnNode currentNode2 = null;
        AbstractInsnNode finalReturn = null;
        for (AbstractInsnNode currentNode2 : m.instructions) {
            if (currentNode2.getOpcode() != 177) continue;
            finalReturn = currentNode2;
        }
        if (finalReturn == null) {
            System.out.println("Failed to find final return " + m.name + m.desc);
        }
        return finalReturn;
    }

    public byte[] patch_playerTexture(byte[] bytes, boolean isObf) {
        String cResourceLocation = c_ResourceLocation.get(isObf);
        String getDefaultSkin = m_getDefaultSkin.get(isObf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        classNode.methods.iterator();
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(getDefaultSkin) || !m.desc.equals("(Ljava/util/UUID;)L" + cResourceLocation + ";")) continue;
            System.out.println("[Gender][GENDERCORE]Found method " + m.name + m.desc);
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/ipixeli/gender/client/Renders", "onEvent", "(Ljava/util/UUID;)L" + cResourceLocation + ";"));
            toInject.add((AbstractInsnNode)new InsnNode(176));
            m.instructions.clear();
            m.instructions.insert(toInject);
            CoreWatcher.PLAYER_TEX.b = true;
            System.out.println("[Gender][GENDERCORE]Patched method " + m.name + m.desc);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] patch_playerScale(byte[] bytes, boolean isObf) {
        String cAbstractClientPlayer = c_AbstractClientPlayer.get(isObf);
        String cEntityLivingBase = c_EntityLivingBase.get(isObf);
        String preRenderCallback = m_preRenderCallback.get(isObf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        classNode.methods.iterator();
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(preRenderCallback) || !m.desc.equals("(L" + cAbstractClientPlayer + ";F)V")) continue;
            System.out.println("[Gender][GENDERCORE]Found method " + m.name + m.desc);
            AbstractInsnNode currentNode2 = null;
            AbstractInsnNode finalReturn = null;
            for (AbstractInsnNode currentNode2 : m.instructions) {
                if (currentNode2.getOpcode() != 177) continue;
                finalReturn = currentNode2;
            }
            if (finalReturn == null) continue;
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/ipixeli/gender/client/Renders", "onEvent", "(L" + cEntityLivingBase + ";)V"));
            m.instructions.insertBefore(finalReturn, toInject);
            CoreWatcher.PLAYER_SCALE.b = true;
            System.out.println("[Gender][GENDERCORE]Patched method " + m.name + m.desc);
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] patch_zombieTexture(byte[] bytes, boolean isObf) {
        String cResourceLocation = c_ResourceLocation.get(isObf);
        String cEntityZombie = c_EntityZombie.get(isObf);
        String getEntityTexture = m_getEntityTexture.get(isObf);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        classNode.methods.iterator();
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(getEntityTexture) || !m.desc.equals("(L" + cEntityZombie + ";)L" + cResourceLocation + ";")) continue;
            System.out.println("[Gender][GENDERCORE]Found method " + m.name + m.desc);
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/ipixeli/gender/client/Renders", "onEvent", "(L" + cEntityZombie + ";)L" + cResourceLocation + ";"));
            toInject.add((AbstractInsnNode)new InsnNode(176));
            m.instructions.clear();
            m.instructions.add(toInject);
            CoreWatcher.ZOMBIE_TEX.b = true;
            System.out.println("[Gender][GENDERCORE]Patched method " + m.name + m.desc);
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

