/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender;

import com.github.ipixeli.gender.Datagram;
import com.github.ipixeli.gender.Logger;
import com.github.ipixeli.gender.client.GenderClient;
import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.Mod;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.server.GenderServer;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.versions.forge.ForgeVersion;

@net.minecraftforge.fml.common.Mod(value="gender")
public final class GenderForge
implements Mod {
    public static final String MC = "1.15.2";
    public static final String VER = "1.7.3";
    public static final String VERSION = "1.7.3+0F(1.15.2)";
    private static GenderForge instance;
    public static final Logger logger;
    private static final String PROTOCOL_VERSION = "1";
    private static final Predicate<String> versions;
    public static final SimpleChannel channel;

    public GenderForge() {
        instance = this;
        new Gender(this, logger);
        logger.logInfo("Gender is version 1.7.3+0F(1.15.2) Environment Version is FORGE " + ForgeVersion.getVersion());
        channel.messageBuilder(Datagram.class, 1).decoder(Datagram::fromBytes).encoder(Datagram::toBytes).consumer(Datagram::onMessage).add();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverSetup);
    }

    public static GenderForge get() {
        return instance;
    }

    private static File checkSetupDirsAndConfig(File cwd) {
        File modDir = new File(cwd + "/config/gender/");
        if (!modDir.exists()) {
            logger.logWarn("Unable to locate missing folder(s): " + modDir.getAbsolutePath());
            if (modDir.mkdirs()) {
                logger.logWarn("Successfully created missing folder(s): " + modDir.getAbsolutePath());
            }
        }
        return modDir;
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent e) {
        File modDir = GenderForge.checkSetupDirsAndConfig(((Minecraft)e.getMinecraftSupplier().get()).field_71412_D);
        GenderClient.onStartup(modDir, (Minecraft)e.getMinecraftSupplier().get());
    }

    @SubscribeEvent
    public void serverSetup(FMLServerStartingEvent e) {
        File modDir = GenderForge.checkSetupDirsAndConfig(e.getServer().func_71238_n());
        GenderServer.onSetup(modDir, e.getServer(), (CommandDispatcher<CommandSource>)e.getCommandDispatcher());
    }

    @Override
    public void sendProfilePacket(PlayerProfile p) {
        channel.sendToServer((Object)new Datagram(p));
    }

    @Override
    public Logger logger() {
        return logger;
    }

    static {
        logger = new Logger();
        versions = v -> PROTOCOL_VERSION.equals(v) || NetworkRegistry.ABSENT.equals(v) || NetworkRegistry.ACCEPTVANILLA.equals(v);
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("gender:gender")).clientAcceptedVersions(versions).serverAcceptedVersions(versions).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

