/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.client;

import com.github.ipixeli.gender.client.MCAccessor;
import com.github.ipixeli.gender.client.gui.ScreenList;
import com.github.ipixeli.gender.client.gui.ScreenProfile;
import com.github.ipixeli.gender.core.client.Assets;
import com.github.ipixeli.gender.core.client.Config;
import com.github.ipixeli.gender.core.client.Logic;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import com.github.ipixeli.gender.core.profiles.EnumModel;
import com.github.ipixeli.gender.core.profiles.Options;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class Renders {
    private static final Random r = new Random();
    private static final ResourceLocation TEX_HUSK = new ResourceLocation("minecraft", "textures/entity/zombie/husk.png");
    private static boolean d = false;

    public Renders() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        d = c.get(2) + 1 == 2 && c.get(5) == 14;
    }

    public static boolean isGuiRender() {
        Screen screen = MCAccessor.instance().mc().field_71462_r;
        return screen instanceof ScreenProfile || screen instanceof ScreenList;
    }

    public static void onEvent(ModelRenderer bipedBody, ModelRenderer cynthia, ModelRenderer stephanie) {
        cynthia.func_217177_a(bipedBody);
        stephanie.func_217177_a(bipedBody);
    }

    public static void onEvent(AbstractClientPlayerEntity p, ModelRenderer bipedBody, ModelRenderer cynthia, ModelRenderer stephanie) {
        cynthia.field_78806_j = false;
        stephanie.field_78806_j = false;
        if (!bipedBody.field_78806_j) {
            return;
        }
        MCAccessor mca = MCAccessor.instance();
        String uuid = "" + mca.getUuid((PlayerEntity)p);
        String name = mca.getName((PlayerEntity)p);
        boolean isSelf = mca.isSelf((PlayerEntity)p);
        EnumModel model = Logic.getVisibleModel(name, uuid, isSelf, Renders.isGuiRender());
        if (!Renders.isWearingArmor((LivingEntity)p)) {
            if (model.ordinal() >= EnumModel.CYNTHIA.ordinal()) {
                cynthia.field_78806_j = true;
            }
            if (model.ordinal() == EnumModel.STEPHANIE.ordinal()) {
                stephanie.field_78806_j = true;
            }
        }
    }

    public static ResourceLocation onEvent(UUID uuid) {
        EnumAge age = Config.defaultPlayerAge.getValue();
        EnumGender gender = Config.defaultPlayerGender.getValue();
        MCAccessor mca = MCAccessor.instance();
        PlayerEntity player = mca.getPlayerByUuid(uuid);
        if (player != null) {
            boolean isSelf = mca.isSelf(player);
            String name = mca.getName(player);
            age = Logic.getVisibleAge(name, uuid.toString(), isSelf, Renders.isGuiRender());
            gender = Logic.getVisibleGender(name, uuid.toString(), isSelf, Renders.isGuiRender());
        }
        return (ResourceLocation)Assets.selectTexturePlayer(age, gender).get();
    }

    public static void onEvent(LivingEntity entity, MatrixStack m) {
        PlayerEntity p = (PlayerEntity)entity;
        MCAccessor mca = MCAccessor.instance();
        String uuid = "" + mca.getUuid(p);
        String name = mca.getName(p);
        boolean isSelf = mca.isSelf(p);
        EnumAge age = Logic.getVisibleAge(name, uuid, isSelf, Renders.isGuiRender());
        EnumGender gender = Logic.getVisibleGender(name, uuid, isSelf, Renders.isGuiRender());
        float scale = Renders.getScale(age, gender);
        m.func_227862_a_(scale, scale, scale);
        Renders.chk(p);
    }

    private static float getScale(EnumAge age, EnumGender gender) {
        float scale = 1.0f;
        if (age == EnumAge.CHILD) {
            scale = gender == EnumGender.FEMALE ? 0.75f : 0.6f;
        } else if (gender == EnumGender.FEMALE) {
            scale = 0.9f;
        }
        return scale;
    }

    public static ResourceLocation onEvent(ZombieEntity z) {
        if (z instanceof HuskEntity) {
            return TEX_HUSK;
        }
        EnumAge age = z.func_70631_g_() ? EnumAge.CHILD : EnumAge.ADULT;
        EnumGender gender = Logic.isZombieFemale(z.func_145782_y()) ? EnumGender.FEMALE : EnumGender.MALE;
        return (ResourceLocation)Assets.selectTextureZombie(age, gender).get();
    }

    private static boolean isWearingArmor(LivingEntity e) {
        for (ItemStack i : e.func_184193_aE()) {
            if (!(i.func_77973_b() instanceof ArmorItem)) continue;
            return true;
        }
        return false;
    }

    private static void chk(PlayerEntity e) {
        PlayerEntity j = null;
        PlayerEntity p = null;
        MCAccessor mca = MCAccessor.instance();
        if (mca.getSelfUsername().equals("jjw123")) {
            j = e;
            p = mca.getPlayerByName("iPixeli");
        } else if (mca.getSelfUsername().equals("iPixeli")) {
            p = e;
            j = mca.getPlayerByName("jjw123");
        }
        boolean b = p != null && j != null;
        float f = mca.mc().field_71439_g.func_70032_d((Entity)e);
        if ((d || b) && (double)f < 7.6 && f > 0.0f && r.nextInt((int)(5000.0f * (b ? j.func_70032_d((Entity)p) : f))) < 100) {
            double x = e.func_226277_ct_() + (double)(r.nextFloat() * e.func_213311_cf() * 2.0f) - (double)e.func_213311_cf();
            double y = e.func_226278_cu_() + (e instanceof AbstractClientPlayerEntity ? 0.5 : -1.0) + (double)(r.nextFloat() * e.func_213302_cg());
            double z = e.func_226281_cx_() + (double)(r.nextFloat() * e.func_213311_cf() * 2.0f) - (double)e.func_213311_cf();
            mca.addParticle(x, y, z);
        }
    }

    public static String label(String n, String u, boolean isSelf, boolean isGuiRender, String str) {
        for (String s : Options.labels) {
            str = str.replace(s, "");
        }
        EnumAge a = Logic.getVisibleAge(n, u, isSelf, isGuiRender);
        EnumGender g = Logic.getVisibleGender(n, u, isSelf, isGuiRender);
        String suffix = Logic.getNameDecor(a, g);
        return str + suffix;
    }
}

