/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.client.gui;

import com.github.ipixeli.gender.client.MCAccessor;
import com.github.ipixeli.gender.client.gui.ScreenBase;
import com.github.ipixeli.gender.core.client.Config;
import com.github.ipixeli.gender.core.client.ConfigSetting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;

public final class ScreenConfig
extends ScreenBase {
    private boolean openedFromModList;

    public ScreenConfig() {
        this(false);
    }

    public ScreenConfig(boolean isPreviousScreenModList) {
        super("Client Configuration");
        this.openedFromModList = isPreviousScreenModList;
    }

    @Override
    public void init(Minecraft mc, int width, int height) {
        super.init(mc, width, height);
        if (this.openedFromModList) {
            ImageButton keep = this.butExit;
            this.buttons.clear();
            this.addButton((Widget)keep);
        }
        int bW = 210;
        int bH = 20;
        int c1x = width / 2 - bW - 1;
        int c2x = width / 2 + 2;
        int halfList = Config.settings.length / 2;
        int y1 = height / 2 - (halfList - 1) * bH;
        int thisX = c1x;
        int thisY = y1;
        int i = 0;
        for (ConfigSetting setting : Config.settings) {
            this.addButton((Widget)new Button(thisX, thisY, bW, bH, setting.name + ": " + setting.getValueStr(), a -> {
                Config.toggle(setting);
                MCAccessor.instance().displayScreen(new ScreenConfig(this.openedFromModList));
            }));
            thisY += bH + 3;
            if ((double)i >= (double)Math.round(halfList) - 0.6 && (double)i <= (double)Math.round(halfList) + 0.6) {
                thisX = c2x;
                thisY = y1;
            }
            ++i;
        }
        this.addButton((Widget)new Button(thisX, thisY, bW, bH, "Set Defaults", a -> {
            Config.defaults();
            Config.updateConfig();
            MCAccessor.instance().displayScreen(new ScreenConfig(this.openedFromModList));
        }));
    }

    @Override
    public void render(int mouseX, int mouseY, float ticks) {
        this.renderDirtBackground(0);
        super.render(mouseX, mouseY, ticks);
    }
}

