/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.client.gui;

import com.github.ipixeli.gender.client.MCAccessor;
import com.github.ipixeli.gender.client.gui.ScreenBase;
import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.Config;
import com.github.ipixeli.gender.core.client.ConfigSetting;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import com.github.ipixeli.gender.core.profiles.EnumModel;
import com.github.ipixeli.gender.core.profiles.Options;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.Util;
import net.minecraftforge.versions.forge.ForgeVersion;

public final class ScreenInfo
extends ScreenBase {
    private static ArrayList<LineData> env = new ArrayList();
    private static ArrayList<LineData> player = new ArrayList();
    private static ArrayList<LineData> config = new ArrayList();
    private static ArrayList<LineData> legend = new ArrayList();
    private static int envWid;
    private static int playerWid;
    private static int configWid;
    private static int legendWid;

    public ScreenInfo() {
        super("Client Information");
    }

    public void init() {
        env.clear();
        player.clear();
        config.clear();
        legend.clear();
        env.add(new LineData("iPixeli's Gender Mod", "1.7.3+0F(1.15.2)"));
        env.add(new LineData("Minecraft", MCAccessor.instance().getMCVer()));
        env.add(new LineData("MinecraftForge", ForgeVersion.getVersion()));
        env.add(new LineData("Minecraft Environment", MCAccessor.instance().isIntegratedServer() ? "Integrated" : "Client"));
        env.add(new LineData("Profiles", "Client:" + Gender.client().getListManager().getList().size() + "; Temp:" + Gender.client().tempMgr.getList().size()));
        String name = MCAccessor.instance().getSelfUsername();
        String uuid = MCAccessor.instance().getSelfUuid();
        String uuidp1 = uuid.substring(0, uuid.length() / 2);
        String uuidp2 = uuid.substring(uuid.length() / 2, uuid.length());
        PlayerProfile clientSelf = Gender.client().getListManager().get(name, uuid);
        player.add(new LineData("Name", name));
        player.add(new LineData("UUID", uuidp1));
        player.add(new LineData("", uuidp2));
        player.add(new LineData("Client", clientSelf == null ? "N/A" : clientSelf.getAge().name() + ", " + clientSelf.getGender().name() + ", " + clientSelf.getModel().name()));
        PlayerProfile tempSelf = Gender.client().tempMgr.get(name, uuid);
        player.add(new LineData("Temp", tempSelf == null ? "N/A" : tempSelf.getAge().name() + ", " + tempSelf.getGender().name() + ", " + tempSelf.getModel().name()));
        for (ConfigSetting setting : Config.settings) {
            String k = setting.getName();
            String v = setting.getValueStr();
            if (setting.getName().startsWith("Enable ")) {
                k = setting.getName().replace("Enable ", "");
                v = v.replace("TRUE", "ENABLED");
                v = v.replace("FALSE", "DISABLED");
            }
            config.add(new LineData(k, v));
        }
        String s = "";
        for (EnumAge e : Options.listAges) {
            s = s + e.getLabel() + e.name().toString() + "; ";
        }
        legend.add(new LineData("Ages", s));
        s = "";
        for (EnumGender e : Options.listGenders) {
            s = s + e.getLabel() + e.name().toString() + "; ";
        }
        legend.add(new LineData("Genders", s));
        s = "";
        for (EnumModel e : Options.listModels) {
            s = s + e.getLabel() + e.name().toString() + "; ";
        }
        legend.add(new LineData("Models", s));
        s = "";
        for (LineData d : env) {
            if (d.label.length() <= s.length()) continue;
            s = d.label;
        }
        envWid = this.font.func_78256_a(s + " ");
        s = "";
        for (LineData d : player) {
            if (d.label.length() <= s.length()) continue;
            s = d.label;
        }
        playerWid = this.font.func_78256_a(s + " ");
        s = "";
        for (LineData d : config) {
            if (d.label.length() <= s.length()) continue;
            s = d.label;
        }
        configWid = this.font.func_78256_a(s + " ");
        s = "";
        for (LineData d : legend) {
            if (d.label.length() <= s.length()) continue;
            s = d.label;
        }
        legendWid = this.font.func_78256_a(s + " ");
        this.addButton((Widget)new Button(this.width / 2 - 149, this.height - 55, 298, 20, "Downloads & Help? -> Click to view on CurseForge", onPress -> {
            try {
                Util.func_110647_a().func_195639_a(new URL("https://www.curseforge.com/minecraft/mc-mods/gender"));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }));
    }

    @Override
    public void render(int mX, int mY, float ticks) {
        this.renderDirtBackground(0);
        super.render(mX, mY, ticks);
        int border = 1;
        int bottom = this.drawSection("ENVIRONMENT", env, border, 26 + border, this.width / 2 - 6 - border / 2, envWid + 2, border);
        this.drawSection("CONFIGURATION", config, border, bottom, this.width / 2 - 6 - border / 2, configWid + 2, border);
        bottom = this.drawSection("PLAYER INFO", player, this.width / 2 + border - 6, 26 + border, this.width - 2, playerWid + 2, border);
        this.drawSection("LEGEND", legend, this.width / 2 - 6 + border, bottom, this.width - border, legendWid + border, border);
    }

    private int drawSection(String name, ArrayList<LineData> list, int boundLeft, int boundTop, int boundRight, int x2Offset, int border) {
        int boundBottom = boundTop + (list.size() + 1) * 10 - 1;
        int y = boundTop + border;
        int x1 = boundLeft + border + 2;
        ScreenInfo.fill((int)(boundLeft + border), (int)(boundTop + border), (int)(boundRight - border), (int)(y + 11), (int)2007682303);
        y = boundTop + border + 2;
        this.font.func_211126_b(name, (float)x1, (float)y, 0xFFFFFF);
        y += 11;
        for (LineData d : list) {
            int c = 0xCCCCCC;
            if (d.value.equals("ENABLED") || d.value.equals("TRUE")) {
                c = 0xAAFFAA;
            } else if (d.value.equals("DISABLED") || d.value.equals("FALSE")) {
                c = 0xFFAAAA;
            }
            this.font.func_211126_b(d.label, (float)x1, (float)y, 0xFFFFFF);
            this.font.func_211126_b(d.value, (float)(boundRight - this.font.func_78256_a(d.value) - 1), (float)y, c);
            y += 9;
        }
        return boundBottom;
    }

    private final class LineData {
        public String label;
        public String value;

        private LineData(String l, String v) {
            this.label = l;
            this.value = v;
        }
    }
}

