/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.options;

import com.github.ipixeli.gender.core.options.EnumGender;
import com.github.ipixeli.gender.core.options.EnumLifeStage;
import com.github.ipixeli.gender.core.options.Option;
import com.github.ipixeli.gender.core.options.Options;

public enum EnumAge implements Option
{
    UNSET(EnumLifeStage.NA, "", "Unset", 1.0, 0.9),
    THREE(EnumLifeStage.CHILD, "3", "3", 0.31, 0.31),
    FOUR(EnumLifeStage.CHILD, "4", "4", 0.35, 0.35),
    FIVE(EnumLifeStage.CHILD, "5", "5", 0.37, 0.37),
    SIX(EnumLifeStage.CHILD, "6", "6", 0.43, 0.43),
    SEVEN(EnumLifeStage.CHILD, "7", "7", 0.47, 0.47),
    EIGHT(EnumLifeStage.CHILD, "8", "8", 0.5, 0.5),
    NINE(EnumLifeStage.CHILD, "9", "9", 0.53, 0.53),
    TEN(EnumLifeStage.CHILD, "10", "10", 0.55, 0.55),
    ELEVEN(EnumLifeStage.CHILD, "11", "11", 0.56, 0.58),
    TWELVE(EnumLifeStage.CHILD, "12", "12", 0.57, 0.6),
    THIRTEEN(EnumLifeStage.TEEN, "13", "13", 0.64, 0.63),
    FOURTEEN(EnumLifeStage.TEEN, "14", "14", 0.7, 0.68),
    FIFTEEN(EnumLifeStage.TEEN, "15", "15", 0.75, 0.72),
    SIXTEEN(EnumLifeStage.TEEN, "16", "16", 0.8, 0.76),
    SEVENTEEN(EnumLifeStage.TEEN, "17", "17", 0.95, 0.9),
    ADULT(EnumLifeStage.ADULT, "", "Adult", 1.0, 1.0);

    public EnumLifeStage lifeStage;
    private String symbol;
    private String renderName;
    private double scaleM;
    private double scaleF;

    private EnumAge(EnumLifeStage l, String s, String r, double m, double f) {
        this.lifeStage = l;
        this.symbol = s;
        this.renderName = r;
        this.scaleM = m;
        this.scaleF = f;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public String getRenderName() {
        return this.renderName;
    }

    public EnumAge getFromValue(Byte byte1) {
        if (Options.listAges.size() > 0) {
            return Options.listAges.stream().filter(opt -> opt.ordinal() == byte1.byteValue()).findFirst().get();
        }
        return Options.listAges.get(0);
    }

    public EnumAge next(boolean skip) {
        EnumAge r = UNSET;
        if (this.ordinal() < Options.listAges.size() - 1) {
            r = Options.listAges.get(this.ordinal() + 1);
        }
        if (skip && r.equals(UNSET)) {
            r = Options.listAges.get(1);
        }
        return r;
    }

    public boolean canUseModelAtAge() {
        return this.lifeStage.equals((Object)EnumLifeStage.ADULT) || this.lifeStage.equals((Object)EnumLifeStage.TEEN);
    }

    public boolean isChild() {
        return !this.lifeStage.equals((Object)EnumLifeStage.NA) && !this.lifeStage.equals((Object)EnumLifeStage.ADULT);
    }

    public double getScale(EnumGender g) {
        return g.equals(EnumGender.MALE) ? this.scaleM : this.scaleF;
    }
}

